/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.easydataaccess;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecside.easydataaccess.SqlParameter;
import org.ecside.easydataaccess.SqlSnippet;

public class EasyDataAccessUtil {
    private static Log logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.ecside.easydataaccess.EasyDataAccessUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
    }

    public static String parseEasySql(String easySql) {
        String newSql = StringUtils.trim((String)easySql);
        newSql = newSql.replaceAll(EasyDataAccessUtil.escRex("#{_L}"), "<");
        newSql = newSql.replaceAll(EasyDataAccessUtil.escRex("#{_G}"), ">");
        newSql = newSql.replaceAll(EasyDataAccessUtil.escRex("!="), "<>");
        return newSql;
    }

    public static String escRex(String in) {
        return in.replaceAll("\\{", "\\\\{").replaceAll("\\}", "\\\\}");
    }

    public static List createSqlSnippets(String inSql) {
        if (inSql == null || inSql.trim().length() < 1) {
            return null;
        }
        ArrayList<SqlSnippet> sqlSnippetList = new ArrayList<SqlSnippet>();
        Pattern pattern = Pattern.compile("#\\{IF:([^\\}]+)\\}*");
        Matcher matcher = pattern.matcher(inSql);
        while (matcher.find()) {
            SqlSnippet sqlSnippet = new SqlSnippet();
            sqlSnippet.start = matcher.start(0);
            sqlSnippet.end = inSql.indexOf("#{/IF}", sqlSnippet.start) + "#{/IF}".length();
            sqlSnippet.condition = matcher.group(1).trim();
            sqlSnippet.snippet = inSql.substring(sqlSnippet.start, sqlSnippet.end).trim();
            sqlSnippet.content = sqlSnippet.snippet.substring(matcher.group(0).length(), sqlSnippet.snippet.length() - "#{/IF}".length()).trim();
            sqlSnippet.init();
            sqlSnippetList.add(sqlSnippet);
        }
        return sqlSnippetList;
    }

    public static PreparedStatement createPreparedStatement(Connection conn, String inSql, Map map) throws SQLException {
        List sqlSnippetList = EasyDataAccessUtil.createSqlSnippets(inSql);
        return EasyDataAccessUtil.createPreparedStatement(conn, inSql, sqlSnippetList, map);
    }

    public static PreparedStatement createPreparedStatement(Connection conn, String inSql, List sqlSnippetList, Map map) throws SQLException {
        ArrayList paraList = new ArrayList();
        return EasyDataAccessUtil.createPreparedStatement(conn, inSql, sqlSnippetList, map, paraList);
    }

    public static PreparedStatement createPreparedStatement(Connection conn, String inSql, List sqlSnippetList, Map map, List paraList) throws SQLException {
        String nsql = EasyDataAccessUtil.getDBSql(inSql, map, paraList, sqlSnippetList);
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(nsql);
            int i = 0;
            while (i < paraList.size()) {
                SqlParameter sqlParameter = (SqlParameter)paraList.get(i);
                pstmt.setString(sqlParameter.getIndex(), sqlParameter.getValueAsString());
                ++i;
            }
        }
        catch (SQLException e) {
            if (pstmt != null) {
                pstmt.close();
            }
            throw e;
        }
        return pstmt;
    }

    public static PreparedStatement createPreparedCallStatement(Connection conn, String inSql, Map map) throws SQLException {
        List sqlSnippetList = EasyDataAccessUtil.createSqlSnippets(inSql);
        return EasyDataAccessUtil.createPreparedCallStatement(conn, inSql, sqlSnippetList, map);
    }

    public static CallableStatement createPreparedCallStatement(Connection conn, String inSql, List sqlSnippetList, Map map) throws SQLException {
        ArrayList paraList = new ArrayList();
        return EasyDataAccessUtil.createPreparedCallStatement(conn, inSql, sqlSnippetList, map, paraList);
    }

    public static CallableStatement createPreparedCallStatement(Connection conn, String inSql, List sqlSnippetList, Map map, List paraList) throws SQLException {
        String nsql = EasyDataAccessUtil.getDBSql(inSql, map, paraList, sqlSnippetList);
        CallableStatement cstmt = null;
        try {
            cstmt = conn.prepareCall(nsql);
            int i = 0;
            while (i < paraList.size()) {
                SqlParameter sqlParameter = (SqlParameter)paraList.get(i);
                if ("out".equals(sqlParameter.getType())) {
                    cstmt.registerOutParameter(sqlParameter.getIndex(), 12);
                } else {
                    cstmt.setString(sqlParameter.getIndex(), sqlParameter.getValueAsString());
                }
                ++i;
            }
        }
        catch (SQLException e) {
            if (cstmt != null) {
                cstmt.close();
            }
            throw e;
        }
        return cstmt;
    }

    public static String getDBSql(String inSql, Map map) {
        List sqlSnippetList = EasyDataAccessUtil.createSqlSnippets(inSql);
        return EasyDataAccessUtil.getDBSql(inSql, map, new ArrayList(), sqlSnippetList);
    }

    public static String getDBSql(String inSql, Map map, List paraList) {
        List sqlSnippetList = EasyDataAccessUtil.createSqlSnippets(inSql);
        return EasyDataAccessUtil.getDBSql(inSql, map, paraList, sqlSnippetList);
    }

    public static String getDBSql(String inSql, Map map, List paraList, List sqlSnippetList) {
        StringBuffer sql = new StringBuffer();
        int start = 0;
        int last = 0;
        if (map == null) {
            map = new HashMap();
        }
        int i = 0;
        i = 0;
        while (i < sqlSnippetList.size()) {
            SqlSnippet sqlSnippet = (SqlSnippet)sqlSnippetList.get(i);
            start = last;
            last = sqlSnippet.start;
            String osql = inSql.substring(start, last);
            sql.append(osql);
            if (sqlSnippet.check(map)) {
                sql.append(sqlSnippet.content);
            }
            last = sqlSnippet.end;
            ++i;
        }
        if (last > 0 && last < inSql.length()) {
            sql.append(inSql.substring(last));
        }
        if (i == 0) {
            sql.append(inSql);
        }
        Pattern pattern = Pattern.compile("#\\{([^_](\\w|:)*[^_\\}])\\}*");
        Matcher matcher = pattern.matcher(sql);
        String outSql = sql.toString();
        int index = 0;
        while (matcher.find()) {
            ++index;
            String pPara = matcher.group(0);
            String pName = matcher.group(1);
            String pType = "in";
            if (pName.startsWith("OUT:")) {
                pName = pName.substring(4);
                pType = "out";
            }
            String pValue = (String)map.get(pName);
            SqlParameter sqlPara = new SqlParameter(pName, pValue, pType);
            sqlPara.setIndex(index);
            paraList.add(sqlPara);
            outSql = StringUtils.replace((String)outSql, (String)pPara, (String)"?");
        }
        StringBuffer stringBuffer = new StringBuffer(" ===== ");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.ecside.easydataaccess.EasyDataAccessUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.debug((Object)stringBuffer.append(clazz.getName()).append(" ===== \n").append(inSql).append("\n").append(outSql).toString());
        return outSql;
    }

    public static boolean isEquals(long a, long b) {
        return a == b;
    }

    public static boolean isNotEquals(long a, long b) {
        return a != b;
    }

    public static boolean isLessThen(long a, long b) {
        return a < b;
    }

    public static boolean isGreatThen(long a, long b) {
        return a > b;
    }

    public static boolean isLessThenE(long a, long b) {
        return a <= b;
    }

    public static boolean isGreatThenE(long a, long b) {
        return a >= b;
    }

    public static boolean isEmpty(String a) {
        return a == null || a.length() < 1;
    }

    public static boolean isNotEmpty(String a) {
        return !EasyDataAccessUtil.isEmpty(a);
    }

    public static boolean isEquals(String a, String b) {
        if (b == null) {
            return a == null;
        }
        return b.equals(a);
    }

    public static boolean isNotEquals(String a, String b) {
        if (b == null) {
            return a != null;
        }
        return !b.equals(a);
    }

    public static boolean isLessThen(String a, String b) {
        return a != null && a.compareTo(b) < 0;
    }

    public static boolean isGreatThen(String a, String b) {
        return a != null && a.compareTo(b) > 0;
    }

    public static boolean isLessThenE(String a, String b) {
        return a != null && (a.compareTo(b) < 0 || a.equals(b));
    }

    public static boolean isGreatThenE(String a, String b) {
        return a != null && (a.compareTo(b) > 0 || a.equals(b));
    }
}

