/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.easylist;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.ecside.easyda.DataAccessHandler;
import org.ecside.easylist.AbstractEasyListModel;
import org.ecside.util.RequestUtils;
import org.ecside.util.ServletUtils;

public class EasyDataAccessHandler
extends DataAccessHandler {
    public void easyList(HttpServletRequest request, HttpServletResponse response, AbstractEasyListModel easyListModel) throws ServletException, IOException {
        if (easyListModel == null) {
            return;
        }
        Map parameterMap = ServletUtils.getParameterMap(request);
        easyListModel.beforeSelect(parameterMap, request, response);
        List rslist = null;
        boolean twiceSelect = true;
        String tableId = easyListModel.getTableId();
        if (StringUtils.isBlank((String)tableId) && StringUtils.isBlank((String)(tableId = request.getParameter("ecTableId")))) {
            tableId = "ec";
        }
        int defaultPageSize = easyListModel.getDefaultPageSize();
        int totalRows = RequestUtils.getTotalRowsFromRequest(request, tableId);
        if (totalRows < 0) {
            totalRows = easyListModel.getRecordsNumber(parameterMap);
        }
        if (totalRows == -101) {
            twiceSelect = false;
            rslist = easyListModel.getRecordsList(parameterMap);
            totalRows = rslist == null ? 0 : rslist.size();
        }
        int[] rowStartEnd = RequestUtils.getRowStartEnd(request, tableId, totalRows, defaultPageSize);
        if (twiceSelect) {
            int size = rowStartEnd[1] - rowStartEnd[0];
            parameterMap.put("ROW_START", String.valueOf(rowStartEnd[0]));
            parameterMap.put("ROW_END", String.valueOf(rowStartEnd[1]));
            parameterMap.put("PAGE_SIZE", String.valueOf(size));
            rslist = easyListModel.getRecordsList(parameterMap);
        }
        String[] titles = null;
        if (easyListModel.getColumnTitles() != null) {
            titles = easyListModel.getColumnTitles().split(",");
        }
        if (rslist != null) {
            request.setAttribute("recordList", (Object)rslist);
        }
        if (parameterMap.get("FIELD_NAMES") != null) {
            request.setAttribute("FIELD_NAMES", parameterMap.get("FIELD_NAMES"));
        }
        if (titles != null) {
            request.setAttribute("TITLE_NAMES", (Object)titles);
        }
        easyListModel.afterSelect(parameterMap, request, response);
    }
}

