/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ECSideAjaxResponseWrapper
extends HttpServletResponseWrapper {
    PrintWriter pw;
    ServletOutputStream sos;
    private StringWriter writerBuffer;
    private ByteArrayOutputStream streamBuffer;
    HttpServletResponse originalResponse;
    private String redirect;

    public ECSideAjaxResponseWrapper(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
        this.originalResponse = httpServletResponse;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writerBuffer == null) {
            this.writerBuffer = new StringWriter();
            this.pw = new PrintWriter(this.writerBuffer);
        }
        return this.pw;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.streamBuffer == null) {
            this.streamBuffer = new ByteArrayOutputStream();
            this.sos = new ServletOutputStream(){

                public void write(int b) throws IOException {
                    ECSideAjaxResponseWrapper.this.streamBuffer.write(b);
                }

                public void write(byte[] b) throws IOException {
                    ECSideAjaxResponseWrapper.this.streamBuffer.write(b);
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    ECSideAjaxResponseWrapper.this.streamBuffer.write(b, off, len);
                }
            };
        }
        return this.sos;
    }

    public void output(String content) throws IOException {
        if (this.streamBuffer != null) {
            this.streamBuffer.write(content.getBytes(this.originalResponse.getCharacterEncoding()));
        } else {
            this.writerBuffer.write(content);
        }
    }

    public String getBuffer() {
        if (this.streamBuffer != null) {
            try {
                return this.streamBuffer.toString(this.originalResponse.getCharacterEncoding());
            }
            catch (UnsupportedEncodingException e) {
                return this.streamBuffer.toString();
            }
        }
        if (this.writerBuffer != null) {
            return this.writerBuffer.toString();
        }
        return "";
    }

    public HttpServletResponse getOriginalResponse() {
        return this.originalResponse;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public void sendRedirect(String redirect) throws IOException {
        this.redirect = redirect;
    }

    public String findSubstring(String firstDelimiter, String lastDelimiter) {
        int p2;
        String content;
        if (this.streamBuffer != null) {
            try {
                content = this.streamBuffer.toString("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                content = this.streamBuffer.toString();
            }
        } else if (this.writerBuffer != null) {
            content = this.writerBuffer.toString();
        } else {
            return null;
        }
        int p1 = content.indexOf(firstDelimiter);
        if (p1 != -1 && (p2 = content.indexOf(lastDelimiter, p1 += firstDelimiter.length())) != -1) {
            return content.substring(p1, p2);
        }
        return content;
    }

    public void setContentType(String string) {
    }

    public void flushBuffer() throws IOException {
    }

    public void setCharacterEncoding(String string) {
    }

    public void setDateHeader(String string, long l) {
    }

    public void addDateHeader(String string, long l) {
    }

    public void setHeader(String string, String string1) {
    }

    public void addHeader(String string, String string1) {
    }

    public void setIntHeader(String string, int i) {
    }

    public void addIntHeader(String string, int i) {
    }

    public StringWriter getWriterBuffer() {
        return this.writerBuffer;
    }

    public ByteArrayOutputStream getStreamBuffer() {
        return this.streamBuffer;
    }
}

