/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.filter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecside.common.log.LogHandler;
import org.ecside.core.ECSideContext;
import org.ecside.core.TableModelUtils;
import org.ecside.core.context.HttpServletRequestContext;
import org.ecside.core.context.ServletInitContext;
import org.ecside.core.context.WebContext;
import org.ecside.easyda.DataAccessModel;
import org.ecside.easyda.DataExportModel;
import org.ecside.easylist.AbstractEasyListModel;
import org.ecside.easylist.EasyDataAccessHandler;
import org.ecside.filter.ECSideAjaxResponseWrapper;
import org.ecside.filter.ExportFilterUtils;
import org.ecside.filter.ExportResponseWrapper;
import org.ecside.preferences.TableProperties;
import org.ecside.resource.MimeUtils;
import org.ecside.util.ECSideUtils;
import org.ecside.util.ExceptionUtils;
import org.ecside.util.RequestUtils;
import org.ecside.view.ViewResolver;

public class ECSideFilter
implements Filter {
    protected static Log logger;
    protected static String encoding;
    protected static boolean useEncoding;
    protected static boolean useEasyDataAccess;
    protected static boolean responseHeadersSetBeforeDoFilter;
    public String servletRealPath;
    public ServletContext servletContext;
    protected FilterConfig filterConfig = null;
    protected EasyDataAccessHandler easyDataAccessHandler;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.ecside.filter.ECSideFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
        encoding = "GBK";
        useEncoding = true;
        useEasyDataAccess = true;
        responseHeadersSetBeforeDoFilter = true;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.servletContext = filterConfig.getServletContext();
        this.servletRealPath = this.servletContext.getRealPath("/");
        this.initEncoding();
        this.initEasyList();
        this.initProperties();
        String responseHeadersSetBeforeDoFilter = filterConfig.getInitParameter("responseHeadersSetBeforeDoFilter");
        if (StringUtils.isNotBlank((String)responseHeadersSetBeforeDoFilter)) {
            ECSideFilter.responseHeadersSetBeforeDoFilter = Boolean.valueOf(responseHeadersSetBeforeDoFilter);
        }
    }

    public void initProperties() throws ServletException {
        ServletInitContext context = new ServletInitContext(this.servletContext);
        TableProperties preferences = new TableProperties();
        preferences.init(context, TableModelUtils.getPreferencesLocation(context));
        ECSideContext.DEFAULT_PAGE_SIZE = new Integer(preferences.getPreference("table.rowsDisplayed"));
    }

    public void initEasyList() throws ServletException {
        useEasyDataAccess = true;
        String useEasyDataAccessC = this.filterConfig.getInitParameter("useEasyDataAccess");
        if ("off".equalsIgnoreCase(useEasyDataAccessC) || "false".equalsIgnoreCase(useEasyDataAccessC) || "no".equals(useEasyDataAccessC) || "0".equals(useEasyDataAccessC)) {
            useEasyDataAccess = false;
        }
        this.easyDataAccessHandler = new EasyDataAccessHandler();
    }

    public void initEncoding() throws ServletException {
        String encodingValue = this.filterConfig.getInitParameter("encoding");
        String useEncodingC = this.filterConfig.getInitParameter("useEncoding");
        if (encodingValue != null && encodingValue.length() > 0) {
            encoding = encodingValue;
        }
        useEncoding = useEncodingC == null || useEncodingC.equalsIgnoreCase("true") || useEncodingC.equalsIgnoreCase("yes") || useEncodingC.equalsIgnoreCase("on") || useEncodingC.equalsIgnoreCase("1");
        ECSideContext.ENCODING = encoding;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (RequestUtils.isAJAXRequest((ServletRequest)request)) {
            this.doAjaxFilter(request, response, chain);
            return;
        }
        this.doEncoding((ServletRequest)request, (ServletResponse)response);
        String easyListName = this.getEasyList((ServletRequest)request);
        String easyDataAccessName = this.getEasyDataAccess((ServletRequest)request);
        String easyDataExport = this.getEasyDataExport((ServletRequest)request);
        HttpServletRequestContext context = new HttpServletRequestContext(request);
        boolean isExported = ExportFilterUtils.isExported(context);
        if (isExported) {
            this.doExportFilter(request, response, chain, context);
            context = null;
            return;
        }
        if (StringUtils.isNotBlank((String)easyDataExport)) {
            String sqlName = ECSideFilter.getSqlName((ServletRequest)request);
            String fileName = ECSideFilter.getExportFileName((ServletRequest)request);
            String type = fileName.substring(fileName.indexOf(46) + 1);
            try {
                this.setResponseHeaders(request, response, fileName);
                this.easyDataAccessHandler.exportList(this.getDataExportModelBean(request, easyDataExport), sqlName, type, request, response);
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
            catch (Exception e) {
                LogHandler.errorLog(logger, e);
            }
            return;
        }
        if (StringUtils.isNotBlank((String)easyListName)) {
            this.easyDataAccessHandler.easyList(request, response, this.getEasyListModelBean(request, easyListName));
        } else if (StringUtils.isNotBlank((String)easyDataAccessName)) {
            String sqlName = ECSideFilter.getSqlName((ServletRequest)request);
            this.easyDataAccessHandler.dataAccess(this.getDataAccessModelBean(request, easyDataAccessName), sqlName, request, response);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void doEncoding(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if ((useEncoding || request.getCharacterEncoding() == null) && encoding != null) {
            request.setCharacterEncoding(encoding);
        }
    }

    public void doAjaxFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        request.setCharacterEncoding("UTF-8");
        String easyListName = this.getEasyList((ServletRequest)request);
        String easyDataAccessName = this.getEasyDataAccess((ServletRequest)request);
        String findAjaxZoneAtClient = request.getParameter("findAjaxZoneAtClient");
        if (findAjaxZoneAtClient != null && ("false".equalsIgnoreCase(findAjaxZoneAtClient) || "0".equals(findAjaxZoneAtClient))) {
            ECSideAjaxResponseWrapper bufferResponseWrapper = new ECSideAjaxResponseWrapper(response);
            try {
                String ectableId = request.getParameter("ec_i");
                if (easyListName != null) {
                    this.easyDataAccessHandler.easyList(request, (HttpServletResponse)bufferResponseWrapper, this.getEasyListModelBean(request, easyListName));
                } else if (easyDataAccessName != null) {
                    String sqlName = ECSideFilter.getSqlName((ServletRequest)request);
                    this.easyDataAccessHandler.dataAccess(this.getDataAccessModelBean(request, easyDataAccessName), sqlName, request, response);
                }
                chain.doFilter((ServletRequest)request, (ServletResponse)bufferResponseWrapper);
                String zone = bufferResponseWrapper.findSubstring(ECSideUtils.getAjaxBegin(ectableId), ECSideUtils.getAjaxEnd(ectableId));
                HttpServletResponse originalResponse = bufferResponseWrapper.getOriginalResponse();
                if (zone != null) {
                    originalResponse.getOutputStream().write(zone.getBytes("UTF-8"));
                }
                originalResponse.getOutputStream().flush();
                originalResponse.getOutputStream().close();
            }
            catch (Exception e) {
                LogHandler.errorLog(logger, e);
                response.setContentType("text/html;charset=UTF-8");
                response.getWriter().println("Exception:<br />\n" + ExceptionUtils.formatStackTrace(e).replaceAll("\n", "<br/>\n"));
                response.getWriter().close();
            }
        } else {
            if (easyListName != null) {
                this.easyDataAccessHandler.easyList(request, response, this.getEasyListModelBean(request, easyListName));
            } else if (easyDataAccessName != null) {
                String sqlName = ECSideFilter.getSqlName((ServletRequest)request);
                this.easyDataAccessHandler.dataAccess(this.getDataAccessModelBean(request, easyDataAccessName), sqlName, request, response);
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void doExportFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain, WebContext context) throws IOException, ServletException {
        String easyListName = this.getEasyList((ServletRequest)request);
        String exportFileName = ExportFilterUtils.getExportFileName(context);
        boolean isPrint = "_print_".equals(exportFileName);
        if (isPrint) {
            if (easyListName != null) {
                this.easyDataAccessHandler.easyList(request, response, this.getEasyListModelBean(request, easyListName));
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            request.setAttribute("RESPONSE_OUTPUTSTREAM_KEY", (Object)response.getOutputStream());
            ExportResponseWrapper responseWrapper = new ExportResponseWrapper(response);
            this.setResponseHeaders(request, response, exportFileName);
            if (easyListName != null) {
                this.easyDataAccessHandler.easyList(request, (HttpServletResponse)responseWrapper, this.getEasyListModelBean(request, easyListName));
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)responseWrapper);
            responseWrapper = null;
        }
        this.handleExport(request, response, context);
    }

    public void handleExport(HttpServletRequest request, HttpServletResponse response, WebContext context) {
        try {
            Object viewData = request.getAttribute("viewData");
            if (viewData != null) {
                TableProperties preferences = new TableProperties();
                preferences.init(null, TableModelUtils.getPreferencesLocation(context));
                String viewResolver = (String)request.getAttribute("viewResolver");
                Class<?> classDefinition = Class.forName(viewResolver);
                ViewResolver handleExportViewResolver = (ViewResolver)classDefinition.newInstance();
                request.setAttribute("ecs_servletRealPath", (Object)this.servletRealPath);
                handleExportViewResolver.resolveView((ServletRequest)request, (ServletResponse)response, preferences, viewData);
                if (!response.isCommitted()) {
                    response.getOutputStream().flush();
                    response.getOutputStream().close();
                }
            }
        }
        catch (Exception e) {
            LogHandler.errorLog(logger, e);
        }
    }

    public void setResponseHeaders(HttpServletRequest request, HttpServletResponse response, String exportFileName) {
        String mimeType = MimeUtils.getFileMimeType(exportFileName);
        if (StringUtils.isNotBlank((String)mimeType)) {
            response.setContentType(mimeType);
        }
        try {
            exportFileName = RequestUtils.encodeFileName(request, exportFileName);
        }
        catch (UnsupportedEncodingException e) {
            String errorMessage = "Unsupported response.getCharacterEncoding() [UTF-8].";
            LogHandler.errorLog(logger, "TDExportFilter.setResponseHeaders() - " + errorMessage);
        }
        response.setHeader("Content-Disposition", "attachment;filename=\"" + exportFileName + "\"");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        response.setDateHeader("Expires", System.currentTimeMillis() + 1000L);
    }

    protected void webProxy(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String line;
        response.setContentType("text/xml");
        PrintWriter out = response.getWriter();
        URL url = new URL(request.getParameter("url"));
        BufferedReader bf = new BufferedReader(new InputStreamReader(url.openStream()));
        while ((line = bf.readLine()) != null) {
            out.println(line);
        }
        bf.close();
    }

    public String getEasyList(ServletRequest servletRequest) {
        String easyDataAccess = null;
        if (useEasyDataAccess) {
            try {
                easyDataAccess = servletRequest.getParameter("easyList");
            }
            catch (Exception e) {
                easyDataAccess = null;
            }
        }
        return StringUtils.isNotBlank(easyDataAccess) ? easyDataAccess : null;
    }

    public String getEasyDataExport(ServletRequest servletRequest) {
        String easyDataAccess = null;
        if (useEasyDataAccess) {
            easyDataAccess = servletRequest.getParameter("easyDataExport");
        }
        if (StringUtils.isNotBlank(easyDataAccess) && easyDataAccess.indexOf(46) > 0) {
            easyDataAccess = easyDataAccess.substring(0, easyDataAccess.indexOf(46));
        }
        return StringUtils.isNotBlank((String)easyDataAccess) ? easyDataAccess : null;
    }

    public String getEasyDataAccess(ServletRequest servletRequest) {
        String easyDataAccess = null;
        if (useEasyDataAccess) {
            easyDataAccess = servletRequest.getParameter("easyDataAccess");
        }
        if (StringUtils.isNotBlank(easyDataAccess) && easyDataAccess.indexOf(46) > 0) {
            easyDataAccess = easyDataAccess.substring(0, easyDataAccess.indexOf(46));
        }
        return StringUtils.isNotBlank((String)easyDataAccess) ? easyDataAccess : null;
    }

    public static String getExportFileName(ServletRequest servletRequest) {
        String eda;
        String fileName = servletRequest.getParameter("eFileName");
        if (StringUtils.isBlank((String)fileName) && (eda = servletRequest.getParameter("easyDataExport")).indexOf(46) > 0) {
            fileName = eda.substring(eda.indexOf(46) + 1);
        }
        return StringUtils.isNotBlank((String)fileName) ? fileName : null;
    }

    public static String getSqlName(ServletRequest servletRequest) {
        String sqlName = servletRequest.getParameter("eSqlName");
        if (StringUtils.isBlank((String)sqlName)) {
            String eda = servletRequest.getParameter("easyDataAccess");
            if (StringUtils.isBlank((String)eda)) {
                eda = servletRequest.getParameter("easyDataExport");
            }
            if (StringUtils.isNotBlank((String)eda) && eda.indexOf(46) > 0) {
                sqlName = eda.substring(eda.indexOf(46) + 1);
            }
        }
        return StringUtils.isNotBlank((String)sqlName) ? sqlName : null;
    }

    public AbstractEasyListModel getEasyListModelBean(HttpServletRequest request, String beanName) {
        return (AbstractEasyListModel)this.getBean(request, beanName);
    }

    public DataAccessModel getDataAccessModelBean(HttpServletRequest request, String beanName) {
        return (DataAccessModel)this.getBean(request, beanName);
    }

    public DataExportModel getDataExportModelBean(HttpServletRequest request, String beanName) {
        return (DataExportModel)this.getBean(request, beanName);
    }

    public Object getBean(HttpServletRequest request, String beanName) {
        return ExportFilterUtils.getBean(request, beanName);
    }

    public void destroy() {
        this.filterConfig = null;
    }
}

