/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.preferences;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecside.common.log.LogHandler;
import org.ecside.core.Preferences;
import org.ecside.core.TableModel;
import org.ecside.core.context.WebContext;

public class TableProperties
implements Preferences {
    private Log logger;
    private Properties properties;
    static /* synthetic */ Class class$0;

    public TableProperties() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.ecside.preferences.TableProperties");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = LogFactory.getLog((Class)clazz);
        this.properties = new Properties();
    }

    public void init(WebContext context, String preferencesLocation) {
        try {
            InputStream resourceAsStream = TableProperties.getInputStream("ecside.properties", context);
            this.properties.load(resourceAsStream);
            if (StringUtils.isNotBlank((String)preferencesLocation) && (resourceAsStream = TableProperties.getInputStream(preferencesLocation, context)) != null) {
                this.properties.load(resourceAsStream);
            }
        }
        catch (Exception e) {
            LogHandler.errorLog(this.logger, "Could not load the ECSide preferences.", e);
        }
    }

    public String getPreference(String name) {
        return (String)this.properties.get(name);
    }

    public static InputStream getInputStream(String preferencesLocation, WebContext context) throws IOException {
        if (preferencesLocation.startsWith("WEB-INF")) {
            preferencesLocation = "/" + preferencesLocation;
        }
        if (preferencesLocation.startsWith("/WEB-INF")) {
            String path = context.getRealPath("/WEB-INF");
            String name = StringUtils.substringAfter((String)preferencesLocation, (String)"/WEB-INF/");
            return new FileInputStream(String.valueOf(path) + "/" + name);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.ecside.preferences.TableProperties");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getResourceAsStream(preferencesLocation);
    }

    public static String getDefaultPreference(TableModel model, String preferenceName, String nowValue) {
        if (StringUtils.isBlank((String)nowValue)) {
            return model.getPreferences().getPreference(preferenceName);
        }
        return nowValue;
    }
}

