/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.resource;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecside.common.log.LogHandler;
import org.ecside.core.Messages;
import org.ecside.core.TableModelUtils;
import org.ecside.core.context.WebContext;

public class TableResourceBundle
implements Messages {
    private Log logger;
    public static final String EXTREMETABLE_RESOURCE_BUNDLE = "org.ecside.resource.ecsideResourceBundle";
    private ResourceBundle defaultResourceBundle;
    private Locale locale;
    private List customResourceBundleList;
    private static String SPLIT = ",";
    static /* synthetic */ Class class$0;

    public TableResourceBundle() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.ecside.resource.TableResourceBundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = LogFactory.getLog((Class)clazz);
        this.customResourceBundleList = new ArrayList();
    }

    public void init(WebContext context, Locale locale) {
        this.locale = locale;
        this.defaultResourceBundle = this.findResourceBundle(EXTREMETABLE_RESOURCE_BUNDLE, locale);
        String messagesLocations = TableModelUtils.getMessagesLocation(context);
        if (StringUtils.isBlank((String)messagesLocations)) {
            return;
        }
        String[] messagesLocationA = messagesLocations.split(SPLIT);
        int i = 0;
        while (i < messagesLocationA.length) {
            String messagesLocation = messagesLocationA[i].trim();
            if (StringUtils.isNotBlank((String)messagesLocation)) {
                this.customResourceBundleList.add(this.findResourceBundle(messagesLocation, locale));
            }
            ++i;
        }
    }

    private ResourceBundle findResourceBundle(String resourceBundleLocation, Locale locale) {
        try {
            return ResourceBundle.getBundle(resourceBundleLocation, locale, this.getClass().getClassLoader());
        }
        catch (MissingResourceException e) {
            LogHandler.errorLog(this.logger, "The resource bundle [ " + resourceBundleLocation + "] was not found. Make sure the path and resource name is correct.", e);
            return null;
        }
    }

    public String getMessage(String code) {
        return this.getMessage(code, null);
    }

    public String getMessage(String code, Object[] args) {
        String result = null;
        int i = 0;
        while (i < this.customResourceBundleList.size()) {
            ResourceBundle customResourceBundle = (ResourceBundle)this.customResourceBundleList.get(i);
            result = this.findResource(customResourceBundle, code);
            if (result != null) break;
            ++i;
        }
        if (result == null) {
            result = this.findResource(this.defaultResourceBundle, code);
        }
        if (result != null && args != null) {
            MessageFormat formatter = new MessageFormat("");
            formatter.setLocale(this.locale);
            formatter.applyPattern(result);
            result = formatter.format(args);
        }
        return result;
    }

    private String findResource(ResourceBundle resourceBundle, String code) {
        String result = null;
        if (resourceBundle == null) {
            return result;
        }
        try {
            result = resourceBundle.getString(code);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return result;
    }
}

