/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.table.calc;

import java.math.BigDecimal;
import java.util.Collection;
import org.ecside.core.TableModel;
import org.ecside.core.bean.Column;
import org.ecside.table.calc.Calc;
import org.ecside.table.calc.CalcHandler;
import org.ecside.table.calc.CalcUtils;

public class AverageCalc
implements Calc {
    public Number getCalcResult(TableModel model, Column column) {
        Collection rows = model.getCollectionOfFilteredBeans();
        String property = column.getProperty();
        AverageValue totalValue = new AverageValue(rows.size());
        CalcUtils.eachRowCalcValue(totalValue, rows, property);
        return totalValue.getAverageValue();
    }

    private static class AverageValue
    implements CalcHandler {
        private double total = 0.0;
        private double rowCount;

        public AverageValue(double rowCount) {
            this.rowCount = rowCount;
        }

        public void processCalcValue(Number calcValue) {
            this.total += calcValue.doubleValue();
        }

        public Number getAverageValue() {
            if (this.rowCount > 0.0) {
                return new BigDecimal(this.total / this.rowCount);
            }
            return new BigDecimal(0.0);
        }
    }
}

