/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.table.calc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecside.core.TableCache;
import org.ecside.core.TableModel;
import org.ecside.core.bean.Column;
import org.ecside.table.calc.Calc;
import org.ecside.table.calc.CalcHandler;
import org.ecside.table.calc.CalcResult;
import org.ecside.util.ExtremeUtils;

public final class CalcUtils {
    private static Log logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.ecside.table.calc.CalcUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
    }

    private CalcUtils() {
    }

    public static CalcResult[] getCalcResults(TableModel model, Column column) {
        ArrayList<CalcResult> values = new ArrayList<CalcResult>();
        String[] calcs = column.getCalc();
        int i = 0;
        while (i < calcs.length) {
            values.add(CalcUtils.getCalcResultsByPosition(model, column, i));
            ++i;
        }
        return values.toArray(new CalcResult[values.size()]);
    }

    public static CalcResult getCalcResultsByPosition(TableModel model, Column column, int position) {
        String calcClassName = CalcUtils.getCalcClassNameByPosition(model, column, position);
        if (!CalcUtils.isCalcClassName(calcClassName)) {
            return new CalcResult(calcClassName, null);
        }
        Calc calc = TableCache.getInstance().getCalc(calcClassName);
        return new CalcResult(calcClassName, calc.getCalcResult(model, column));
    }

    public static String[] getFirstCalcColumnTitles(TableModel model) {
        ArrayList<String> values = new ArrayList<String>();
        Column column = model.getColumnHandler().getFirstCalcColumn();
        String[] calcs = column.getCalc();
        int i = 0;
        while (i < calcs.length) {
            values.add(CalcUtils.getFirstCalcColumnTitleByPosition(model, i));
            ++i;
        }
        return values.toArray(new String[values.size()]);
    }

    public static String getFirstCalcColumnTitleByPosition(TableModel model, int position) {
        Column column = model.getColumnHandler().getFirstCalcColumn();
        String[] calcTitle = column.getCalcTitle();
        return calcTitle[position];
    }

    private static String getCalcClassNameByPosition(TableModel model, Column column, int position) {
        String[] calcs = column.getCalc();
        String calcName = calcs[position];
        String calcClassName = model.getPreferences().getPreference("column.calc." + calcName);
        if (StringUtils.isBlank((String)calcClassName)) {
            calcClassName = calcName;
        }
        return calcClassName;
    }

    private static boolean isCalcClassName(String calcClassName) {
        try {
            Class.forName(calcClassName);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void eachRowCalcValue(CalcHandler handler, Collection rows, String property) {
        if (rows == null) {
            return;
        }
        Iterator listIter = rows.iterator();
        while (listIter.hasNext()) {
            Object row = listIter.next();
            Object value = null;
            if (!ExtremeUtils.isBeanPropertyReadable(row, property)) continue;
            try {
                value = PropertyUtils.getProperty(row, (String)property);
                if (value instanceof Number) {
                    handler.processCalcValue((Number)value);
                    continue;
                }
                handler.processCalcValue(CalcUtils.getValue(property, value));
            }
            catch (Exception e) {
                String errorMessage = "Problem parsing numeric value for property [" + property + "].";
                logger.warn((Object)("CalcUtils.eachCalc() - " + errorMessage));
            }
        }
    }

    private static Number getValue(String property, Object value) {
        String valueAsString = String.valueOf(value);
        if (StringUtils.isNotBlank((String)valueAsString)) {
            try {
                return new BigDecimal(valueAsString);
            }
            catch (NumberFormatException e) {
                String errorMessage = "Problem parsing numeric value for property [" + property + "] with value [" + valueAsString + "].";
                logger.warn((Object)("CalcUtils.getValue() - " + errorMessage));
            }
        }
        return new BigDecimal(0.0);
    }
}

