/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.table.callback;

import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecside.core.TableModel;
import org.ecside.core.bean.Column;
import org.ecside.util.ECSideUtils;
import org.ecside.util.ExtremeUtils;

public final class FilterPredicate
implements Predicate {
    private Log logger;
    private TableModel model;
    static /* synthetic */ Class class$0;

    public FilterPredicate(TableModel model) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.ecside.table.callback.FilterPredicate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = LogFactory.getLog((Class)clazz);
        this.model = model;
    }

    public boolean evaluate(Object bean) {
        boolean match = false;
        try {
            Iterator iter = this.model.getColumnHandler().getColumns().iterator();
            while (iter.hasNext()) {
                Locale locale;
                String property;
                Object value;
                Column column = (Column)iter.next();
                String alias = column.getAlias();
                String filterValue = this.model.getLimit().getFilterSet().getFilterValue(alias);
                if (StringUtils.isEmpty((String)filterValue) || (value = PropertyUtils.getProperty((Object)bean, (String)(property = column.getProperty()))) == null) continue;
                if (column.isDate()) {
                    locale = this.model.getLocale();
                    value = ExtremeUtils.formatDate(column.getParse(), column.getFormat(), value, locale);
                } else if (column.isCurrency()) {
                    locale = this.model.getLocale();
                    value = ExtremeUtils.formatNumber(column.getFormat(), value, locale);
                }
                if (!ECSideUtils.isSearchMatchCaseIgnore(value.toString(), filterValue)) {
                    match = false;
                    break;
                }
                match = true;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"FilterPredicate.evaluate() had problems", (Throwable)e);
        }
        return match;
    }
}

