/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.table.callback;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.comparators.NullComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecside.core.RetrievalUtils;
import org.ecside.core.TableModel;
import org.ecside.core.bean.Table;
import org.ecside.table.callback.FilterPredicate;
import org.ecside.table.callback.FilterRowsCallback;
import org.ecside.table.callback.NullSafeBeanComparator;
import org.ecside.table.callback.RetrieveRowsCallback;
import org.ecside.table.callback.SortRowsCallback;
import org.ecside.table.limit.Sort;

public class ProcessRowsCallback
implements RetrieveRowsCallback,
FilterRowsCallback,
SortRowsCallback {
    private Log logger;
    static /* synthetic */ Class class$0;

    public ProcessRowsCallback() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.ecside.table.callback.ProcessRowsCallback");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = LogFactory.getLog((Class)clazz);
    }

    public Collection retrieveRows(TableModel model) throws Exception {
        Table table = model.getTable();
        return RetrievalUtils.retrieveCollection(model.getContext(), table.getItems(), table.getScope());
    }

    public Collection filterRows(TableModel model, Collection rows) throws Exception {
        boolean filtered = model.getLimit().isFiltered();
        boolean cleared = model.getLimit().isCleared();
        if (!filtered || cleared) {
            return rows;
        }
        if (filtered) {
            ArrayList collection = new ArrayList();
            FilterPredicate filterPredicate = new FilterPredicate(model);
            CollectionUtils.select((Collection)rows, (Predicate)filterPredicate, collection);
            return collection;
        }
        return rows;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collection sortRows(TableModel model, Collection rows) throws Exception {
        boolean sorted = model.getLimit().isSorted();
        if (!sorted) {
            return rows;
        }
        Sort sort = model.getLimit().getSort();
        String property = sort.getProperty();
        String sortOrder = sort.getSortOrder();
        if (StringUtils.contains((String)property, (String)".")) {
            try {
                if (sortOrder.equals("asc")) {
                    Collections.sort((List)rows, new NullSafeBeanComparator(property, (Comparator)new NullComparator()));
                    return rows;
                }
                if (!sortOrder.equals("desc")) return rows;
                NullSafeBeanComparator reversedNaturalOrderBeanComparator = new NullSafeBeanComparator(property, (Comparator)new ReverseComparator((Comparator)new NullComparator()));
                Collections.sort((List)rows, reversedNaturalOrderBeanComparator);
                return rows;
            }
            catch (NoClassDefFoundError e) {
                String msg = "The column property [" + property + "] is nested and requires BeanUtils 1.7 or greater for proper sorting.";
                this.logger.error((Object)msg);
                throw new NoClassDefFoundError(msg);
            }
        } else if (sortOrder.equals("asc")) {
            BeanComparator comparator = new BeanComparator(property, (Comparator)new NullComparator());
            Collections.sort((List)rows, comparator);
            return rows;
        } else {
            if (!sortOrder.equals("desc")) return rows;
            BeanComparator reversedNaturalOrderBeanComparator = new BeanComparator(property, (Comparator)new ReverseComparator((Comparator)new NullComparator()));
            Collections.sort((List)rows, reversedNaturalOrderBeanComparator);
        }
        return rows;
    }
}

