/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.table.cell;

import org.ecside.core.TableModel;
import org.ecside.core.TableModelUtils;
import org.ecside.core.bean.Column;
import org.ecside.table.cell.Cell;
import org.ecside.util.ECSideUtils;
import org.ecside.view.html.ColumnBuilder;

public abstract class AbstractRowCalcCell
implements Cell {
    public String getHtmlDisplay(TableModel model, Column column) {
        ColumnBuilder columnBuilder = new ColumnBuilder(column);
        columnBuilder.tdStart();
        columnBuilder.tdBody(this.getCellValue(model, column));
        columnBuilder.tdEnd();
        return columnBuilder.toString();
    }

    public String getExportDisplay(TableModel model, Column column) {
        return column.getPropertyValueAsString();
    }

    public static String getPropertyStringValue(Object rowBean, String propertyName) {
        Object propertyValue = TableModelUtils.getColumnPropertyValue(rowBean, propertyName);
        return ECSideUtils.convertString(propertyValue, "");
    }

    public static double getPropertyNumberValue(Object rowBean, String propertyName) {
        Object propertyValue = TableModelUtils.getColumnPropertyValue(rowBean, propertyName);
        double numberValue = 0.0;
        if (propertyValue == null) {
            return numberValue;
        }
        try {
            numberValue = Double.valueOf(propertyValue.toString());
        }
        catch (Exception e) {
            numberValue = 0.0;
        }
        return numberValue;
    }

    public abstract String getCellValue(TableModel var1, Column var2);
}

