/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.table.cell;

import org.apache.commons.lang.StringUtils;
import org.ecside.core.TableModel;
import org.ecside.core.bean.Column;
import org.ecside.table.cell.Cell;
import org.ecside.util.HtmlBuilder;
import org.ecside.view.html.ColumnBuilder;

public class CheckBoxCell
implements Cell {
    public String getHtmlDisplay(TableModel model, Column column) {
        ColumnBuilder columnBuilder = new ColumnBuilder(column);
        columnBuilder.tdStart();
        columnBuilder.tdBody(this.getCellValue(model, column));
        columnBuilder.tdEnd();
        return columnBuilder.toString();
    }

    public String getExportDisplay(TableModel model, Column column) {
        return "";
    }

    protected String getCellValue(TableModel model, Column column) {
        String value = column.getValueAsString();
        String checkBoxName = column.getAlias();
        HtmlBuilder build = new HtmlBuilder();
        build.input("checkbox").name(checkBoxName).value(value);
        if (column.getStyleClass() != null) {
            build.styleClass(column.getStyleClass());
        } else {
            build.styleClass("checkbox");
        }
        if (StringUtils.isNotBlank((String)column.getTagAttributes())) {
            build.append(" ").append(column.getTagAttributes()).append(" ");
        }
        build.xclose();
        return build.toString();
    }
}

