/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.table.cell;

import org.apache.commons.lang.StringUtils;
import org.ecside.core.TableModel;
import org.ecside.core.bean.Column;
import org.ecside.table.cell.Cell;
import org.ecside.util.ECSideUtils;
import org.ecside.view.html.ColumnBuilder;

public class DisplayCell
implements Cell {
    public String getHtmlDisplay(TableModel model, Column column) {
        ColumnBuilder columnBuilder = new ColumnBuilder(column);
        columnBuilder.tdStart();
        columnBuilder.tdBody(this.getCellValue(model, column));
        columnBuilder.tdEnd();
        return columnBuilder.toString();
    }

    public String getExportDisplay(TableModel model, Column column) {
        return column.getPropertyValueAsString();
    }

    protected String getCellValue(TableModel model, Column column) {
        boolean useEllipsis;
        boolean bl = useEllipsis = column.getEllipsis() == null ? false : column.getEllipsis();
        if (useEllipsis) {
            StringBuffer cellHtml = new StringBuffer();
            cellHtml.append("<div class=\"ellipsis\" ");
            String width = column.getWidth();
            if (StringUtils.isNotBlank((String)width) && !width.endsWith("%")) {
                cellHtml.append(" style=\"width:" + width + "px\" ");
            }
            cellHtml.append("title=\"").append(ECSideUtils.HTMLToTEXT(column.getValueAsString())).append("\" >");
            cellHtml.append(column.getValueAsString());
            cellHtml.append("</div>");
            return cellHtml.toString();
        }
        return column.getValueAsString();
    }
}

