/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.table.cell;

import java.math.BigDecimal;
import org.apache.commons.lang.StringUtils;
import org.ecside.core.TableModel;
import org.ecside.core.TableModelUtils;
import org.ecside.core.bean.Column;
import org.ecside.table.cell.Cell;
import org.ecside.view.html.ColumnBuilder;

public class RowCalcAvgCell
implements Cell {
    public String getHtmlDisplay(TableModel model, Column column) {
        ColumnBuilder columnBuilder = new ColumnBuilder(column);
        columnBuilder.tdStart();
        columnBuilder.tdBody(this.getCellValue(model, column));
        columnBuilder.tdEnd();
        return columnBuilder.toString();
    }

    public String getExportDisplay(TableModel model, Column column) {
        return column.getPropertyValueAsString();
    }

    protected String getCellValue(TableModel model, Column column) {
        Object rowBean = model.getCurrentRowBean();
        String property = column.getProperty();
        Object[] propertyNameList = "*".equals(property) || StringUtils.isBlank((String)property) ? model.getPropertyNameList().toArray() : property.split(",");
        double totalValue = 0.0;
        int num = 0;
        int i = 0;
        while (i < propertyNameList.length) {
            String propertyName = (String)propertyNameList[i];
            Object propertyValue = TableModelUtils.getColumnPropertyValue(rowBean, propertyName);
            try {
                totalValue += Double.parseDouble((String)propertyValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        num = propertyNameList.length;
        column.setValue(new BigDecimal(totalValue / (double)num));
        column.setPropertyValue(column.getValue());
        return column.getValueAsString();
    }
}

