/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.table.handler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.ecside.core.TableCache;
import org.ecside.core.TableModel;
import org.ecside.core.TableModelUtils;
import org.ecside.core.bean.Column;
import org.ecside.table.calc.CalcResult;
import org.ecside.table.calc.CalcUtils;
import org.ecside.table.cell.Cell;

public class ColumnHandler {
    private TableModel model;
    private List columns = new ArrayList();
    private Column firstColumn;
    private Column lastColumn;

    public ColumnHandler(TableModel model) {
        this.model = model;
    }

    public void addAutoGenerateColumn(Column column) {
        column.setAttribute("isAutoGenerateColumn", "true");
        this.addColumn(column);
    }

    public void addColumn(Column column) {
        column.defaults();
        this.addColumnAttributes(column);
        if (!this.isViewAllowed(column)) {
            return;
        }
        if (this.firstColumn == null) {
            this.firstColumn = column;
            column.setFirstColumn(true);
        }
        if (this.lastColumn != null) {
            this.lastColumn.setLastColumn(false);
        }
        this.lastColumn = column;
        column.setLastColumn(true);
        this.columns.add(column);
        this.model.addPropertyName(column.getProperty());
    }

    public void addColumnAttributes(Column column) {
        String interceptor = TableModelUtils.getInterceptPreference(this.model, column.getInterceptor(), "column.interceptor.");
        column.setInterceptor(interceptor);
        TableCache.getInstance().getColumnInterceptor(interceptor).addColumnAttributes(this.model, column);
    }

    public void modifyColumnAttributes(Column column) {
        TableCache.getInstance().getColumnInterceptor(column.getInterceptor()).modifyColumnAttributes(this.model, column);
    }

    public int columnCount() {
        return this.columns.size();
    }

    public List getColumns() {
        return this.columns;
    }

    public Column getColumnByAlias(String alias) {
        Iterator iter = this.columns.iterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            String columnAlias = column.getAlias();
            if (columnAlias == null || !columnAlias.equals(alias)) continue;
            return column;
        }
        return null;
    }

    public boolean hasMetatData() {
        return this.columnCount() > 0;
    }

    public List getFilterColumns() {
        boolean cleared = this.model.getLimit().isCleared();
        Iterator iter = this.columns.iterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            String value = this.model.getLimit().getFilterSet().getFilterValue(column.getAlias());
            if (cleared || StringUtils.isEmpty((String)value)) {
                value = "";
            }
            Cell cell = TableModelUtils.getFilterCell(column, value);
            column.setCellDisplay(cell.getHtmlDisplay(this.model, column));
        }
        return this.columns;
    }

    public List getHeaderColumns() {
        Iterator iter = this.columns.iterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            Cell cell = TableModelUtils.getHeaderCell(column, column.getTitle());
            boolean isExported = this.model.getLimit().isExported();
            if (!isExported) {
                column.setCellDisplay(cell.getHtmlDisplay(this.model, column));
                continue;
            }
            boolean isPrint = this.model.getExportHandler().getCurrentExport().getView().equals("print");
            if (isPrint) {
                column.setCellDisplay(cell.getHtmlDisplay(this.model, column));
                continue;
            }
            column.setCellDisplay(cell.getExportDisplay(this.model, column));
        }
        return this.columns;
    }

    private boolean isViewAllowed(Column column) {
        boolean denyView;
        boolean allowView;
        String view = this.model.getTable().getView();
        boolean isExported = this.model.getLimit().isExported();
        if (isExported) {
            view = this.model.getExportHandler().getCurrentExport().getView();
        }
        return (allowView = this.allowView(column, view)) & !(denyView = this.denyView(column, view));
    }

    private boolean allowView(Column column, String view) {
        String[] viewsAllowed = column.getViewsAllowed();
        if (viewsAllowed == null || viewsAllowed.length == 0) {
            return true;
        }
        int i = 0;
        while (i < viewsAllowed.length) {
            if (view.equals(viewsAllowed[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean denyView(Column column, String view) {
        String[] viewsDenied = column.getViewsDenied();
        if (viewsDenied == null || viewsDenied.length == 0) {
            return false;
        }
        int i = 0;
        while (i < viewsDenied.length) {
            if (view.equals(viewsDenied[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Column getFirstCalcColumn() {
        Iterator iter = this.columns.iterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            if (!column.isCalculated()) continue;
            return column;
        }
        return null;
    }

    public CalcResult[] getCalcResults(Column column) {
        if (!column.isCalculated()) {
            return null;
        }
        return CalcUtils.getCalcResults(this.model, column);
    }
}

