/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.table.handler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecside.core.TableCache;
import org.ecside.core.TableModel;
import org.ecside.core.TableModelUtils;
import org.ecside.core.bean.Export;

public class ExportHandler {
    private Log logger;
    private TableModel model;
    private List exports;
    static /* synthetic */ Class class$0;

    public ExportHandler(TableModel model) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.ecside.table.handler.ExportHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = LogFactory.getLog((Class)clazz);
        this.exports = new ArrayList();
        this.model = model;
    }

    public void addExport(Export export) {
        this.exports.add(export);
        this.addExportAttributes(export);
        export.defaults();
    }

    public void addExportAttributes(Export export) {
        String interceptor = TableModelUtils.getInterceptPreference(this.model, export.getInterceptor(), "export.interceptor.");
        export.setInterceptor(interceptor);
        TableCache.getInstance().getExportInterceptor(interceptor).addExportAttributes(this.model, export);
    }

    public Export getExport(String view) {
        Iterator iter = this.exports.iterator();
        while (iter.hasNext()) {
            Export export = (Export)iter.next();
            if (!export.getView().equals(view)) continue;
            return export;
        }
        return null;
    }

    public Export getCurrentExport() {
        String prefixWithTableId = this.model.getTableHandler().prefixWithTableId();
        String exportView = this.model.getRegistry().getParameter(String.valueOf(prefixWithTableId) + "ev");
        Export export = this.getExport(exportView);
        if (export == null) {
            String msg = "There is no export defined. This commonly happens if you do not declare the export (Export or ExportTag) before the row and columns.";
            this.logger.error((Object)msg);
            throw new IllegalStateException(msg);
        }
        return export;
    }

    public List getExports() {
        return this.exports;
    }

    public boolean isExported() {
        return this.model.getExportHandler().isExported();
    }
}

