/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.table.handler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecside.core.TableCache;
import org.ecside.core.TableModel;
import org.ecside.core.TableModelUtils;
import org.ecside.core.bean.Row;

public class RowHandler {
    private Log logger;
    private TableModel model;
    private Row row;
    static /* synthetic */ Class class$0;

    public RowHandler(TableModel model) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.ecside.table.handler.RowHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = LogFactory.getLog((Class)clazz);
        this.model = model;
    }

    public TableModel getModel() {
        return this.model;
    }

    public Row getRow() {
        return this.row;
    }

    public void addRow(Row row) {
        this.row = row;
        this.addRowAttributes();
        row.defaults();
    }

    public void addRowAttributes() {
        String interceptor = TableModelUtils.getInterceptPreference(this.model, this.row.getInterceptor(), "row.interceptor.");
        this.row.setInterceptor(interceptor);
        TableCache.getInstance().getRowInterceptor(interceptor).addRowAttributes(this.model, this.row);
    }

    public void modifyRowAttributes() {
        TableCache.getInstance().getRowInterceptor(this.row.getInterceptor()).modifyRowAttributes(this.model, this.row);
    }

    public boolean isRowEven() {
        return this.row.getRowCount() != 0 && this.row.getRowCount() % 2 == 0;
    }

    public boolean isRowOdd() {
        return this.row.getRowCount() == 0 || this.row.getRowCount() % 2 != 0;
    }

    public int increaseRowCount() {
        if (this.row == null) {
            String msg = "There is no row defined. The row (Row or RowTag) is now required and needs to be put around the columns.";
            this.logger.error((Object)msg);
            throw new IllegalStateException(msg);
        }
        this.row.setRowCount(this.row.getRowCount() + 1);
        return this.row.getRowCount();
    }
}

