/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.table.handler;

import org.ecside.core.TableCache;
import org.ecside.core.TableModel;
import org.ecside.core.TableModelUtils;
import org.ecside.core.bean.Table;

public class TableHandler {
    protected TableModel model;
    private Table table;

    public TableHandler(TableModel model) {
        this.model = model;
    }

    public Table getTable() {
        return this.table;
    }

    public void addTable(Table table) {
        this.table = table;
        this.addTableAttributes();
        table.defaults();
    }

    public void addTableAttributes() {
        String interceptor = TableModelUtils.getInterceptPreference(this.model, this.table.getInterceptor(), "table.interceptor.");
        this.table.setInterceptor(interceptor);
        TableCache.getInstance().getTableInterceptor(interceptor).addTableAttributes(this.model, this.table);
    }

    public String prefixWithTableId() {
        return String.valueOf(this.table.getTableId()) + "_";
    }

    public Integer getTotalRows() {
        return (Integer)this.table.getAttribute("totalRows");
    }

    public void setTotalRows(Integer totalRows) {
        this.table.setAttribute("totalRows", totalRows);
    }
}

