/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.table.handler;

import org.apache.commons.lang.StringUtils;
import org.ecside.core.TableModel;
import org.ecside.core.TableModelUtils;
import org.ecside.core.bean.Column;
import org.ecside.table.cell.Cell;
import org.ecside.util.ECSideUtils;
import org.ecside.view.View;

public class ViewHandler {
    private TableModel model;
    private View view;

    public ViewHandler(TableModel model) {
        this.model = model;
    }

    public View getView() {
        return this.view;
    }

    public void setView() throws Exception {
        String preference;
        boolean isExported = this.model.getLimit().isExported();
        String currentView = null;
        if (isExported) {
            currentView = this.model.getExportHandler().getCurrentExport().getView();
            preference = this.model.getPreferences().getPreference("export.view." + currentView);
            if (StringUtils.isNotBlank((String)preference)) {
                currentView = preference;
            }
        } else {
            currentView = this.model.getTable().getView();
            preference = this.model.getPreferences().getPreference("table.view." + currentView);
            if (StringUtils.isNotBlank((String)preference)) {
                currentView = preference;
            }
        }
        Class<?> classDefinition = Class.forName(currentView);
        this.view = (View)classDefinition.newInstance();
        this.getView().beforeBody(this.model);
    }

    public void addColumnValueToView(Column column) {
        Cell cell = TableModelUtils.getCell(column);
        boolean isExported = this.model.getLimit().isExported();
        if (!isExported) {
            column.setCellDisplay(cell.getHtmlDisplay(this.model, column));
        } else {
            boolean isPrint = this.model.getExportHandler().getCurrentExport().getView().equals("print");
            if (isPrint) {
                column.setCellDisplay(cell.getHtmlDisplay(this.model, column));
            } else {
                column.setCellDisplay(ECSideUtils.HTMLToTEXT(cell.getHtmlDisplay(this.model, column)).trim());
            }
        }
        this.getView().body(this.model, column);
    }
}

