/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.table.limit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.ecside.core.Registry;
import org.ecside.core.context.WebContext;
import org.ecside.table.limit.Filter;
import org.ecside.table.limit.FilterSet;
import org.ecside.table.limit.LimitFactory;
import org.ecside.table.limit.Sort;

public abstract class AbstractLimitFactory
implements LimitFactory {
    protected String tableId;
    protected String prefixWithTableId;
    protected boolean isExported;
    protected Registry registry;
    protected WebContext context;

    public boolean isExported() {
        return this.isExported;
    }

    public String getTableId() {
        return this.tableId;
    }

    public WebContext getWebContext() {
        return this.context;
    }

    boolean isExportPage() {
        String exportPage = this.context.getParameter("eti_p");
        return "true".equalsIgnoreCase(exportPage);
    }

    boolean getExported() {
        String exportTableId = this.context.getParameter("eti");
        if (StringUtils.isBlank((String)exportTableId)) {
            return false;
        }
        return exportTableId.equals(this.tableId);
    }

    public int getCurrentRowsDisplayed(int totalRows, int rowsDisplayed) {
        if (this.isExported && !this.isExportPage() || !this.showPagination()) {
            return totalRows;
        }
        String currentRowsDisplayed = this.registry.getParameter(String.valueOf(this.prefixWithTableId) + "crd");
        if (StringUtils.isNotBlank((String)currentRowsDisplayed)) {
            return Integer.parseInt(currentRowsDisplayed);
        }
        return rowsDisplayed;
    }

    public int getPage() {
        if (this.isExported && !this.isExportPage()) {
            return 1;
        }
        String page = this.registry.getParameter(String.valueOf(this.prefixWithTableId) + "p");
        if (!StringUtils.isEmpty((String)page)) {
            return Integer.parseInt(page);
        }
        return 1;
    }

    public Sort getSort() {
        Map sortedParameters = this.getSortedOrFilteredParameters("s_");
        if (sortedParameters == null) {
            return new Sort();
        }
        Iterator iter = sortedParameters.keySet().iterator();
        if (iter.hasNext()) {
            String propertyOrAlias = (String)iter.next();
            String value = (String)sortedParameters.get(propertyOrAlias);
            if (value.equals("default")) {
                return new Sort();
            }
            String property = this.getProperty(propertyOrAlias);
            return new Sort(propertyOrAlias, property, value);
        }
        return new Sort();
    }

    public FilterSet getFilterSet() {
        Map filteredParameters = this.getSortedOrFilteredParameters("f_");
        FilterSet filterSet = this.getFilterSet(filteredParameters);
        if (filterSet.isCleared()) {
            this.removeFilterParameters();
            filterSet = new FilterSet(filterSet.getAction(), new Filter[0]);
        }
        return filterSet;
    }

    void removeFilterParameters() {
        Set set = this.registry.getParameterMap().keySet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!name.startsWith(String.valueOf(this.prefixWithTableId) + "f_")) continue;
            iter.remove();
        }
    }

    FilterSet getFilterSet(Map filteredParameters) {
        if (filteredParameters == null) {
            return new FilterSet();
        }
        String action = (String)filteredParameters.get("a");
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Iterator iter = filteredParameters.keySet().iterator();
        while (iter.hasNext()) {
            String propertyOrAlias = (String)iter.next();
            String value = (String)filteredParameters.get(propertyOrAlias);
            if (StringUtils.isBlank((String)value) || propertyOrAlias.equals("a")) continue;
            String property = this.getProperty(propertyOrAlias);
            filters.add(new Filter(propertyOrAlias, property, value));
        }
        return new FilterSet(action, filters.toArray(new Filter[filters.size()]));
    }

    public Map getSortedOrFilteredParameters(String parameter) {
        HashMap<String, String> subset = new HashMap<String, String>();
        String find = String.valueOf(this.prefixWithTableId) + parameter;
        Set set = this.registry.getParameterMap().keySet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            String value;
            String key = (String)iter.next();
            if (!key.startsWith(find) || !StringUtils.isNotBlank((String)(value = this.registry.getParameter(key)))) continue;
            String propertyOrAlias = StringUtils.substringAfter((String)key, (String)find);
            subset.put(propertyOrAlias, value);
        }
        return subset;
    }

    private String getProperty(String propertyOrAlias) {
        String property = this.registry.getParameter(String.valueOf(this.prefixWithTableId) + "a_" + propertyOrAlias);
        if (StringUtils.isNotBlank((String)property)) {
            return property;
        }
        return propertyOrAlias;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("tableId", (Object)this.tableId);
        return builder.toString();
    }

    protected abstract boolean showPagination();
}

