/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.table.limit;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.ecside.table.limit.Filter;

public class FilterSet {
    private String action;
    private Filter[] filters;
    private Map propertyValueMap;
    private Map aliasValueMap;

    public FilterSet() {
    }

    public FilterSet(String action, Filter[] filters) {
        this.action = action;
        this.filters = filters;
        if (filters.length > 0) {
            this.propertyValueMap = new HashMap();
            this.aliasValueMap = new HashMap();
            int i = 0;
            while (i < filters.length) {
                this.aliasValueMap.put(filters[i].getAlias(), filters[i].getValue());
                this.propertyValueMap.put(filters[i].getProperty(), filters[i].getValue());
                ++i;
            }
        }
    }

    public boolean isFiltered() {
        return this.action != null && this.action.equals("fa") && this.filters != null && this.filters.length > 0;
    }

    public boolean isCleared() {
        return this.action != null && this.action.equals("ca");
    }

    public String getAction() {
        return this.action;
    }

    public Filter[] getFilters() {
        return this.filters;
    }

    public String getFilterValue(String alias) {
        int i = 0;
        while (i < this.filters.length) {
            Filter filter = this.filters[i];
            if (filter.getAlias().equals(alias)) {
                return filter.getValue();
            }
            ++i;
        }
        return "";
    }

    public Filter getFilter(String alias) {
        int i = 0;
        while (i < this.filters.length) {
            Filter filter = this.filters[i];
            if (filter.getAlias().equals(alias)) {
                return filter;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("action", (Object)this.action);
        if (this.filters != null) {
            int i = 0;
            while (i < this.filters.length) {
                Filter filter = this.filters[i];
                builder.append((Object)filter.toString());
                ++i;
            }
        }
        return builder.toString();
    }

    public Map getAliasValueMap() {
        return this.aliasValueMap;
    }

    public Map getPropertyValueMap() {
        return this.propertyValueMap;
    }
}

