/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.table.tool;

import org.ecside.core.TableModel;
import org.ecside.table.tool.BaseTool;
import org.ecside.util.HtmlBuilder;

public class AddTool
extends BaseTool {
    public AddTool() {
    }

    public AddTool(HtmlBuilder html, TableModel model) {
        super(html, model);
    }

    public void buildTool() {
        if (!this.getTableModel().getTable().isEditable()) {
            return;
        }
        boolean showTooltips = this.getTableModel().getTable().isShowTooltips();
        String action = this.getToolAction();
        this.getHtmlBuilder().td(1).nowrap().styleClass("addTool").close();
        this.getHtmlBuilder().append("<nobr>");
        this.getHtmlBuilder().input().type("button");
        this.getHtmlBuilder().styleClass("toolButton girdAdd");
        this.getHtmlBuilder().onclick(action);
        if (showTooltips) {
            this.getHtmlBuilder().title(this.getTableModel().getMessages().getMessage("toolbar.text.add"));
        }
        this.getHtmlBuilder().xclose();
        this.getHtmlBuilder().append("</nobr>");
        this.getHtmlBuilder().tdEnd();
    }

    public String getToolAction() {
        String formId = this.getTableModel().getTable().getTableId();
        String templateId = this.getTableModel().getPreferences().getPreference("table.addTemplate");
        StringBuffer action = new StringBuffer("ECSideUtil.addToGird(");
        action.append("this,'" + formId + '_' + templateId + "', '" + formId + "'");
        action.append(");");
        String onInvokeAction = this.getTableModel().getTable().getOnInvokeAction();
        if (onInvokeAction != null && onInvokeAction.length() > 0) {
            action.append(onInvokeAction);
        }
        return action.toString();
    }
}

