/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.table.tool;

import java.util.Iterator;
import org.ecside.core.TableModel;
import org.ecside.core.bean.Export;
import org.ecside.table.tool.BaseTool;
import org.ecside.util.HtmlBuilder;

public class ExportTool
extends BaseTool {
    public ExportTool() {
    }

    public ExportTool(HtmlBuilder html, TableModel model) {
        super(html, model);
    }

    public void buildTool() {
        Iterator iterator;
        this.getHtmlBuilder().td(1).nowrap().styleClass("exportTool").close();
        this.getHtmlBuilder().append("<nobr>");
        Iterator iter = iterator = this.getTableModel().getExportHandler().getExports().iterator();
        while (iter.hasNext()) {
            Export export = (Export)iter.next();
            this.exportItemAsButton(export);
        }
        this.getHtmlBuilder().append("</nobr>");
        this.getHtmlBuilder().tdEnd();
    }

    public static void buildExportIframe(HtmlBuilder html, TableModel model) {
        html.append("<iframe style=\"border:0px;\" marginwidth=\"0\" marginheight=\"0\" frameborder=\"0\" border=\"0\" width=\"0\" height=\"0\"");
        html.append(" id=\"").append(String.valueOf(model.getTableHandler().prefixWithTableId()) + "ecs_export_iframe");
        html.append("\" name=\"").append(String.valueOf(model.getTableHandler().prefixWithTableId()) + "ecs_export_iframe");
        html.append("\" ></iframe>");
    }

    public void exportItemAsButton(Export export) {
        String action = this.getExportAction(this.getTableModel().getTable().getTableId(), export.getView(), export.getFileName());
        this.getHtmlBuilder().input().type("button");
        if ("xls".equals(export.getView())) {
            this.getHtmlBuilder().styleClass("toolButton exportXls");
        } else if ("pdf".equals(export.getView())) {
            this.getHtmlBuilder().styleClass("toolButton exportPdf");
        } else if ("csv".equals(export.getView())) {
            this.getHtmlBuilder().styleClass("toolButton exportCsv");
        } else if ("print".equals(export.getView())) {
            this.getHtmlBuilder().styleClass("toolButton exportPrint");
        }
        boolean showTooltips = this.getTableModel().getTable().isShowTooltips();
        this.getHtmlBuilder().onclick(action);
        this.getHtmlBuilder().alt(export.getText());
        if (showTooltips) {
            this.getHtmlBuilder().title(export.getTooltip());
        }
        this.getHtmlBuilder().xclose();
    }

    public String getExportAction(String formId, String exportView, String exportFileName) {
        StringBuffer action = new StringBuffer();
        String exportPage = "";
        action.append("ECSideUtil.doExport(");
        action.append("'" + exportView + "',");
        action.append("'" + exportFileName + "',");
        action.append("'" + exportPage + "',");
        action.append("'" + formId + "'");
        action.append(");");
        return action.toString();
    }
}

