/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.table.tool;

import org.ecside.core.TableModel;
import org.ecside.table.tool.BaseTool;
import org.ecside.util.HtmlBuilder;

public class PageJumpTool
extends BaseTool {
    public PageJumpTool() {
    }

    public PageJumpTool(HtmlBuilder html, TableModel model) {
        super(html, model);
    }

    public void buildTool() {
        int currentRowsDisplayed = this.getTableModel().getLimit().getCurrentRowsDisplayed();
        int currentPage = this.getTableModel().getLimit().getPage();
        int totalPages = 0;
        int totalRows = this.getTableModel().getLimit().getTotalRows();
        if (currentRowsDisplayed > 0) {
            totalPages = (int)Math.ceil((double)totalRows / (double)currentRowsDisplayed);
        } else {
            totalPages = 1;
            currentPage = 1;
        }
        boolean showTooltips = this.getTableModel().getTable().isShowTooltips();
        String action = this.getGotoPagesAction();
        this.getHtmlBuilder().td(1).styleClass("pageJumpTool").nowrap();
        this.getHtmlBuilder().onmouseover("ECSideUtil.NearPagesBar.showMe(this,'" + this.getTableModel().getTable().getTableId() + "');");
        this.getHtmlBuilder().onmouseout("ECSideUtil.NearPagesBar.hideMe(this,'" + this.getTableModel().getTable().getTableId() + "');");
        this.getHtmlBuilder().close();
        this.getHtmlBuilder().append("<nobr>");
        this.getHtmlBuilder().input().type("button");
        this.getHtmlBuilder().styleClass("pageNav jumpPage");
        this.getHtmlBuilder().onclick(action);
        if (showTooltips) {
            this.getHtmlBuilder().title(this.getTableModel().getMessages().getMessage("toolbar.text.pagejump"));
        }
        this.getHtmlBuilder().xclose();
        this.getHtmlBuilder().input("text").name(String.valueOf(this.getPrefixWithTableId()) + "pg");
        this.getHtmlBuilder().value("" + currentPage);
        this.getHtmlBuilder().styleClass("jumpPageInput");
        this.getHtmlBuilder().append(" onkeydown=\"if (event.keyCode && event.keyCode==13 ) {" + action + ";return false; } \" ");
        this.getHtmlBuilder().xclose();
        this.getHtmlBuilder().append("/").append("" + totalPages).append(this.getTableModel().getMessages().getMessage("toolbar.text.pageName"));
        this.getHtmlBuilder().append("</nobr>");
        this.getHtmlBuilder().tdEnd();
    }

    public String getGotoPagesAction() {
        String formId = this.getTableModel().getTable().getTableId();
        StringBuffer action = new StringBuffer("ECSideUtil.gotoPageByInput(");
        action.append("this,'" + formId + "'");
        action.append(");");
        String onInvokeAction = this.getTableModel().getTable().getOnInvokeAction();
        if (onInvokeAction != null && onInvokeAction.length() > 0) {
            action.append(onInvokeAction);
        }
        return action.toString();
    }
}

