/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.table.tool;

import org.ecside.core.TableModel;
import org.ecside.table.tool.BaseTool;
import org.ecside.util.HtmlBuilder;
import org.ecside.view.html.BuilderUtils;

public class PageNavigationTool
extends BaseTool {
    public PageNavigationTool() {
    }

    public PageNavigationTool(HtmlBuilder html, TableModel model) {
        super(html, model);
    }

    public void buildTool() {
        this.getHtmlBuilder().td(1).styleClass("pageNavigationTool").nowrap().close();
        this.firstPageItemAsButton();
        this.prevPageItemAsButton();
        this.getHtmlBuilder().tdEnd();
        this.getHtmlBuilder().td(1).styleClass("pageNavigationTool").nowrap().close();
        this.nextPageItemAsButton();
        this.lastPageItemAsButton();
        this.getHtmlBuilder().tdEnd();
    }

    public void firstPageItemAsButton() {
        boolean showTooltips = this.getTableModel().getTable().isShowTooltips();
        boolean isEnabled = BuilderUtils.isFirstPageEnabled(this.getTableModel().getLimit().getPage());
        this.getHtmlBuilder().input().type("button");
        String disabled = null;
        if (!isEnabled) {
            disabled = "D";
            this.getHtmlBuilder().disabled();
        } else {
            disabled = "";
        }
        this.getHtmlBuilder().styleClass("pageNav firstPage" + disabled);
        this.getHtmlBuilder().onclick(this.getPageNavAction(1));
        if (showTooltips) {
            this.getHtmlBuilder().title(this.getMessages().getMessage("toolbar.tooltip.firstPage"));
        }
        this.getHtmlBuilder().xclose();
    }

    public void prevPageItemAsButton() {
        int prevPage = this.getTableModel().getLimit().getPage() - 1;
        boolean showTooltips = this.getTableModel().getTable().isShowTooltips();
        boolean isEnabled = BuilderUtils.isPrevPageEnabled(this.getTableModel().getLimit().getPage());
        this.getHtmlBuilder().input().type("button");
        String disabled = null;
        if (!isEnabled) {
            disabled = "D";
            this.getHtmlBuilder().disabled();
        } else {
            disabled = "";
        }
        this.getHtmlBuilder().styleClass("pageNav prevPage" + disabled);
        this.getHtmlBuilder().onclick(this.getPageNavAction(prevPage));
        if (showTooltips) {
            this.getHtmlBuilder().title(this.getMessages().getMessage("toolbar.tooltip.prevPage"));
        }
        this.getHtmlBuilder().xclose();
    }

    public void nextPageItemAsButton() {
        int nextPage = this.getTableModel().getLimit().getPage() + 1;
        int lastPage = BuilderUtils.getTotalPages(this.getTableModel());
        boolean showTooltips = this.getTableModel().getTable().isShowTooltips();
        boolean isEnabled = BuilderUtils.isNextPageEnabled(this.getTableModel().getLimit().getPage(), lastPage);
        this.getHtmlBuilder().input().type("button");
        String disabled = null;
        if (!isEnabled) {
            disabled = "D";
            this.getHtmlBuilder().disabled();
        } else {
            disabled = "";
        }
        this.getHtmlBuilder().styleClass("pageNav nextPage" + disabled);
        this.getHtmlBuilder().onclick(this.getPageNavAction(nextPage));
        if (showTooltips) {
            this.getHtmlBuilder().title(this.getMessages().getMessage("toolbar.tooltip.nextPage"));
        }
        if (!isEnabled) {
            this.getHtmlBuilder().disabled();
        }
        this.getHtmlBuilder().xclose();
    }

    public void lastPageItemAsButton() {
        int lastPage = BuilderUtils.getTotalPages(this.getTableModel());
        boolean showTooltips = this.getTableModel().getTable().isShowTooltips();
        boolean isEnabled = BuilderUtils.isLastPageEnabled(this.getTableModel().getLimit().getPage(), lastPage);
        this.getHtmlBuilder().input().type("button");
        String disabled = null;
        if (!isEnabled) {
            disabled = "D";
            this.getHtmlBuilder().disabled();
        } else {
            disabled = "";
        }
        this.getHtmlBuilder().styleClass("pageNav lastPage" + disabled);
        this.getHtmlBuilder().onclick(this.getPageNavAction(lastPage));
        if (showTooltips) {
            this.getHtmlBuilder().title(this.getMessages().getMessage("toolbar.tooltip.lastPage"));
        }
        if (!isEnabled) {
            this.getHtmlBuilder().disabled();
        }
        this.getHtmlBuilder().xclose();
    }

    public String getPageNavAction(int page) {
        String formId = this.getTableModel().getTable().getTableId();
        StringBuffer action = new StringBuffer("ECSideUtil.gotoPage(");
        action.append(String.valueOf(page) + ",'" + formId + "'");
        action.append(");");
        String onInvokeAction = this.getTableModel().getTable().getOnInvokeAction();
        if (onInvokeAction != null && onInvokeAction.length() > 0) {
            action.append(onInvokeAction);
        }
        return action.toString();
    }
}

