/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.table.tool;

import org.apache.commons.lang.StringUtils;
import org.ecside.core.TableModel;
import org.ecside.table.tool.BaseTool;
import org.ecside.util.HtmlBuilder;

public class PageSizeTool
extends BaseTool {
    public PageSizeTool() {
    }

    public PageSizeTool(HtmlBuilder html, TableModel model) {
        super(html, model);
    }

    public void buildTool() {
        this.getHtmlBuilder().td(1).styleClass("pageSizeTool").nowrap().close();
        this.getHtmlBuilder().append(this.getTableModel().getMessages().getMessage("toolbar.text.pageSize.perpage"));
        this.rowsDisplayedDroplist();
        this.getHtmlBuilder().append(this.getTableModel().getMessages().getMessage("toolbar.text.pageSize.record"));
        this.getHtmlBuilder().tdEnd();
    }

    public void rowsDisplayedDroplist() {
        int allRowsDisplayed = this.getTableModel().getLimit().getTotalRows();
        int currentRowsDisplayed = this.getTableModel().getLimit().getCurrentRowsDisplayed();
        int rowsDisplayed = this.getTableModel().getTable().getRowsDisplayed();
        String pageSizeList = this.getTableModel().getTable().getPageSizeList();
        String[] sizeList = null;
        if (pageSizeList != null) {
            sizeList = StringUtils.split((String)pageSizeList, (String)",");
        }
        this.getHtmlBuilder().select().name(String.valueOf(this.getTableModel().getTableHandler().prefixWithTableId()) + "rd");
        String formId = this.getTableModel().getTable().getTableId();
        StringBuffer onchange = new StringBuffer();
        onchange.append("ECSideUtil.changeRowsDisplayed(");
        onchange.append("'" + formId + "',this);");
        this.getHtmlBuilder().onchange(onchange.toString());
        this.getHtmlBuilder().close();
        this.getHtmlBuilder().newline();
        this.getHtmlBuilder().tabs(4);
        int i = 0;
        int maxSize = Integer.MAX_VALUE;
        boolean hasDefaultSize = false;
        if (sizeList != null) {
            i = 0;
            while (i < sizeList.length) {
                block18: {
                    int size = 0;
                    if (sizeList[i].trim().toLowerCase().startsWith("max:")) {
                        try {
                            if (maxSize == Integer.MAX_VALUE) {
                                maxSize = new Integer(sizeList[i].substring(4));
                            }
                        }
                        catch (Exception e) {
                            maxSize = Integer.MAX_VALUE;
                        }
                    } else {
                        String text;
                        if (allRowsDisplayed < maxSize && "all".equalsIgnoreCase(sizeList[i].trim())) {
                            size = allRowsDisplayed;
                            text = this.getTableModel().getMessages().getMessage("toolbar.text.all");
                        } else {
                            try {
                                size = Integer.parseInt(sizeList[i].trim());
                                text = String.valueOf(size);
                            }
                            catch (Exception ei) {
                                break block18;
                            }
                        }
                        if (!hasDefaultSize) {
                            boolean bl = hasDefaultSize = size == currentRowsDisplayed;
                        }
                        if (size <= maxSize) {
                            this.getHtmlBuilder().option().value(String.valueOf(size));
                            if (currentRowsDisplayed == size) {
                                this.getHtmlBuilder().selected();
                            }
                            this.getHtmlBuilder().close();
                            this.getHtmlBuilder().append(text);
                            this.getHtmlBuilder().optionEnd();
                        }
                    }
                }
                ++i;
            }
        }
        if (i == 0 || !hasDefaultSize) {
            if (rowsDisplayed > allRowsDisplayed) {
                rowsDisplayed = allRowsDisplayed;
            }
            this.getHtmlBuilder().option().value(String.valueOf(rowsDisplayed));
            if (currentRowsDisplayed == rowsDisplayed) {
                this.getHtmlBuilder().selected();
            }
            this.getHtmlBuilder().close();
            this.getHtmlBuilder().append(String.valueOf(rowsDisplayed));
            this.getHtmlBuilder().optionEnd();
        }
        this.getHtmlBuilder().newline();
        this.getHtmlBuilder().tabs(4);
        this.getHtmlBuilder().selectEnd();
    }
}

