/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.table.tool;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecside.common.log.LogHandler;
import org.ecside.core.TableModel;
import org.ecside.table.tool.BaseTool;
import org.ecside.util.ECSideUtils;
import org.ecside.util.HtmlBuilder;
import org.ecside.view.html.BuilderUtils;

public class ToolBarBuilder {
    private Log logger;
    public static final String TOOL_NEWLINE = ",";
    public static final String TOOL_SEPARATOR = "|";
    public static final Map toolClassPool = Collections.synchronizedMap(new HashMap());
    private HtmlBuilder html;
    private TableModel model;
    private String toolbarContent;
    private String[] toolNames;
    static /* synthetic */ Class class$0;

    public static void registeredTool(String toolName, Class classDefinition) {
        toolClassPool.put(toolName, classDefinition);
    }

    public BaseTool loadTool(String toolName) {
        String excludeTool = TOOL_NEWLINE + this.model.getTable().getExcludeTool() + TOOL_NEWLINE;
        if (excludeTool.indexOf(toolName) >= 0) {
            return null;
        }
        toolName = this.model.getPreferences().getPreference("tool." + toolName);
        if (toolName == null) {
            return null;
        }
        BaseTool tool = null;
        try {
            Class<?> classDefinition = (Class<?>)toolClassPool.get(toolName);
            if (classDefinition == null) {
                classDefinition = Class.forName(toolName);
                ToolBarBuilder.registeredTool(toolName, classDefinition);
            }
            tool = (BaseTool)classDefinition.newInstance();
            tool.setHtmlBuilder(this.html);
            tool.setTableModel(this.model);
            tool.setMessages(this.model.getMessages());
        }
        catch (Exception e) {
            LogHandler.errorLog(this.logger, e);
        }
        return tool;
    }

    public void buildToolBar() {
        boolean showToolBar = true;
        boolean filterable = BuilderUtils.filterable(this.model);
        boolean showExports = BuilderUtils.showExports(this.model);
        if (!showToolBar || this.toolNames == null && !filterable && !showExports) {
            return;
        }
        String width = this.model.getTable().getWidth();
        if (width.indexOf("px") == -1 && width.indexOf("%") == -1) {
            width = String.valueOf(width) + "px";
        }
        this.html.newline();
        this.html.div().id(String.valueOf(this.model.getTableHandler().prefixWithTableId()) + "toolbar").styleClass("toolbar").style("width:" + width + ";").close();
        this.html.table(1).id(String.valueOf(this.model.getTableHandler().prefixWithTableId()) + "toolbarTable").styleClass("toolbarTable").cellPadding("0").cellSpacing("0").close();
        this.html.tr(1).close();
        BaseTool tempTool = null;
        if (this.toolNames != null) {
            int i = 0;
            while (i < this.toolNames.length) {
                if (this.toolNames[i].indexOf(" ") < 0) {
                    tempTool = this.loadTool(this.toolNames[i]);
                    if (tempTool != null) {
                        tempTool.buildTool();
                        this.html.newline();
                    }
                } else {
                    String[] stoolNames = this.toolNames[i].trim().split(" ");
                    int si = 0;
                    while (si < stoolNames.length) {
                        tempTool = this.loadTool(stoolNames[si]);
                        if (tempTool != null) {
                            tempTool.buildTool();
                            this.html.newline();
                        }
                        ++si;
                    }
                }
                ++i;
            }
        }
        this.html.trEnd(1);
        this.html.tableEnd(1);
        this.html.divEnd();
        this.html.div().id(String.valueOf(this.model.getTableHandler().prefixWithTableId()) + "toolbarShadow").style("display:none;").close().divEnd();
    }

    public ToolBarBuilder(HtmlBuilder html, TableModel model, String toolbarContent) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.ecside.table.tool.ToolBarBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = LogFactory.getLog((Class)clazz);
        this.html = html;
        this.model = model;
        this.toolbarContent = toolbarContent;
        String toolbarContentT = ECSideUtils.replace(toolbarContent, TOOL_SEPARATOR, ";|;");
        toolbarContentT = ECSideUtils.replace(toolbarContentT, TOOL_NEWLINE, ";,;");
        this.toolNames = toolbarContentT.split(";");
    }

    protected HtmlBuilder getHtmlBuilder() {
        return this.html;
    }

    protected TableModel getTableModel() {
        return this.model;
    }

    public String getToolbarContent() {
        return this.toolbarContent;
    }

    public void setToolbarContent(String toolbarContent) {
        this.toolbarContent = toolbarContent;
    }
}

