/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.tag;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager;
import org.ecside.core.TableModel;
import org.ecside.core.TableModelUtils;
import org.ecside.core.bean.BaseBean;
import org.ecside.core.bean.GirdExpression;
import org.ecside.tag.TableTag;
import org.ecside.util.ExceptionUtils;

public final class TagUtils {
    private static Log logger;
    public static final Map escape_REX;
    public static final String VAR_EX = "VAR";
    public static final String REX_EX = "(^VAR|\\W+VAR)\\.(\\w+)";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.ecside.tag.TagUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
        escape_REX = new HashMap();
        escape_REX.put("html", new String[]{"#\\[(ESC_HTML:)([^\\]]+)\\]*", "#\\^(ESC_HTML:)([^\\^]+)\\^*", "#~(ESC_HTML:)([^~]+~)*"});
        escape_REX.put("xml", new String[]{"#\\[(ESC_XML:)([^\\]]+)\\]*", "#\\^(ESC_XML:)([^\\^]+)\\^*", "#~(ESC_XML:)([^~]+)~*"});
        escape_REX.put("js", new String[]{"#\\[(ESC_JS:)([^\\]]+)\\]*", "#\\^(ESC_JS:)([^\\^]+)\\^*", "#~(ESC_JS:)([^~]+)~*"});
    }

    public static void main(String[] args) {
    }

    private TagUtils() {
    }

    public static final String escapeString(String value, String escapeType) {
        if ("html".equals(escapeType)) {
            value = StringEscapeUtils.escapeHtml((String)value);
        } else if ("xml".equals(escapeType)) {
            value = StringEscapeUtils.escapeXml((String)value);
        } else if ("js".equals(escapeType)) {
            value = StringEscapeUtils.escapeJavaScript((String)value);
        }
        return value;
    }

    public static final String escapeExpression(String attribute, String escapeType) {
        String[] escapeRexs = (String[])escape_REX.get(escapeType);
        int i = 0;
        while (i < escapeRexs.length) {
            Pattern pattern = Pattern.compile(escapeRexs[i]);
            Matcher matcher = pattern.matcher(attribute);
            StringBuffer attributeBuffer = new StringBuffer();
            int lastIndex = 0;
            while (matcher.find()) {
                String pEsc = matcher.group(0);
                String pEscValue = matcher.group(2);
                pEscValue = TagUtils.escapeString(pEscValue, escapeType);
                int start = matcher.start(0);
                attributeBuffer.append(attribute.substring(lastIndex, start));
                attributeBuffer.append(pEscValue);
                lastIndex = start + pEsc.length();
            }
            attributeBuffer.append(attribute.substring(lastIndex));
            attribute = attributeBuffer.toString();
            ++i;
        }
        return attribute;
    }

    public static final String evaluateExpressionAsString(String attributeName, String attribute, Tag tag, PageContext pageContext) {
        block6: {
            try {
                if (attribute == null) break block6;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((attribute = (String)ExpressionEvaluatorManager.evaluate((String)attributeName, (String)attribute, (Class)clazz, (Tag)tag, (PageContext)pageContext)) != null && attribute.startsWith("#_ESCAPE:")) {
                    attribute = attribute.substring("#_ESCAPE:".length());
                    attribute = TagUtils.escapeExpression(attribute, "html");
                    attribute = TagUtils.escapeExpression(attribute, "xml");
                    attribute = TagUtils.escapeExpression(attribute, "js");
                }
            }
            catch (JspException e) {
                logger.error((Object)("Could not resolve EL for [" + attributeName + "] - " + ExceptionUtils.formatStackTrace(e)));
            }
        }
        return attribute;
    }

    public static final void initExpression(String expressionKey, String expressionStr, BaseBean bBean) {
        if (expressionStr == null) {
            return;
        }
        bBean.addExpressionPropertys(expressionKey, null);
        expressionStr = expressionStr.trim();
        if (expressionStr.startsWith("#_EX:")) {
            ArrayList<String> expressionPropertys = new ArrayList<String>();
            expressionStr = expressionStr.substring("#_EX:".length());
            Pattern pattern = Pattern.compile(REX_EX);
            Matcher matcher = pattern.matcher(expressionStr);
            while (matcher.find()) {
                expressionPropertys.add(matcher.group(2));
            }
            if (expressionPropertys.size() > 0) {
                bBean.addExpressionPropertys(expressionKey, expressionPropertys.toArray());
            }
            GirdExpression calcEX = new GirdExpression();
            calcEX.build(VAR_EX, expressionStr);
            bBean.addExpression(expressionKey, calcEX);
        }
    }

    public static final Object runExpression(String expressionKey, BaseBean bBean, Object currentBean) {
        Object[] expressionPropertys = bBean.getExpressionPropertys(expressionKey);
        if (expressionPropertys != null) {
            GirdExpression expression = bBean.getExpression(expressionKey);
            int i = 0;
            while (i < expressionPropertys.length) {
                String ep = (String)expressionPropertys[i];
                expression.setArgument(ep, TableModelUtils.getColumnPropertyValue(currentBean, ep));
                ++i;
            }
            return expression.call();
        }
        return null;
    }

    public static final Object evaluateExpressionAsObject(String attributeName, Object attribute, Tag tag, PageContext pageContext) {
        try {
            String attributeS;
            if (attribute != null) {
                String string = attribute.toString();
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                attribute = ExpressionEvaluatorManager.evaluate((String)attributeName, (String)string, (Class)clazz, (Tag)tag, (PageContext)pageContext);
            }
            if (attribute instanceof String && (attributeS = attribute.toString()).startsWith("#_ESCAPE:")) {
                attributeS = attributeS.substring("#_ESCAPE:".length());
                attributeS = TagUtils.escapeExpression(attributeS, "html");
                attributeS = TagUtils.escapeExpression(attributeS, "xml");
                attributeS = TagUtils.escapeExpression(attributeS, "js");
                attribute = attributeS;
            }
        }
        catch (JspException e) {
            logger.error((Object)("Could not resolve EL for [" + attributeName + "] - " + ExceptionUtils.formatStackTrace(e)));
        }
        return attribute;
    }

    public static final Collection evaluateExpressionAsCollection(String attributeName, Object attribute, Tag tag, PageContext pageContext) {
        if ((attribute = TagUtils.evaluateExpressionAsObject(attributeName, attribute, tag, pageContext)) == null || !(attribute instanceof Collection)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The attribute [" + attributeName + "] is null or not a Collection."));
            }
            return null;
        }
        return (Collection)attribute;
    }

    public static final Boolean evaluateExpressionAsBoolean(String attributeName, String attribute, Tag tag, PageContext pageContext) {
        if ((attribute = TagUtils.evaluateExpressionAsString(attributeName, attribute, tag, pageContext)) == null) {
            return null;
        }
        return Boolean.valueOf(attribute);
    }

    public static final int evaluateExpressionAsInt(String attributeName, String attribute, Tag tag, PageContext pageContext) {
        if ((attribute = TagUtils.evaluateExpressionAsString(attributeName, attribute, tag, pageContext)) == null) {
            return 0;
        }
        return new Integer(attribute);
    }

    public static TableModel getModel(Tag tag) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.ecside.tag.TableTag");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TableTag tableTag = (TableTag)TagSupport.findAncestorWithClass((Tag)tag, (Class)clazz);
        return tableTag.getModel();
    }

    public static boolean isIteratingBody(Tag tag) {
        return TagUtils.getModel(tag).getCurrentRowBean() != null;
    }
}

