/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.ecside.core.TableModel;
import org.ecside.core.bean.Tr;

public class ECSideUtils {
    public static String getApplicationName(String servletPath) {
        int first = servletPath.indexOf("/");
        if (first < 0) {
            return "";
        }
        int second = servletPath.indexOf("/", first + 1);
        if (second < 0) {
            return "";
        }
        return servletPath.substring(first + 1, second);
    }

    public static String encodeFileName(String fileName, String agent) throws UnsupportedEncodingException {
        String codedfilename = null;
        fileName = fileName.replaceAll("\n|\r", " ").trim();
        codedfilename = agent != null && -1 != agent.indexOf("MSIE") ? URLEncoder.encode(fileName, "UTF8") : (agent != null && -1 != agent.indexOf("Mozilla") ? "=?UTF-8?B?" + new String(Base64.encodeBase64((byte[])fileName.getBytes("UTF-8"))) + "?=" : fileName);
        return codedfilename;
    }

    public static String GBToISO(String gb) {
        try {
            return gb == null ? gb : new String(gb.getBytes("GB2312"), "ISO-8859-1");
        }
        catch (Exception e) {
            return gb;
        }
    }

    public static String ISOToGB(String iso) {
        try {
            return iso == null ? iso : new String(iso.getBytes("ISO-8859-1"), "GB2312");
        }
        catch (Exception e) {
            return iso;
        }
    }

    public static int parseInt(String val, int defaultValue) {
        int result = 0;
        try {
            result = Integer.parseInt(val);
        }
        catch (Exception e) {
            result = defaultValue;
        }
        return result;
    }

    public static int parseInt(String val) {
        int result = 0;
        try {
            result = Integer.parseInt(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static long parseLong(String value, long defaultValue) {
        long result = 0L;
        try {
            result = Long.parseLong(value);
        }
        catch (Exception ex) {
            result = defaultValue;
        }
        return result;
    }

    public static long parseLong(String value) {
        long result = 0L;
        try {
            result = Long.parseLong(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static float parseFloat(String value) {
        float result = 0.0f;
        try {
            result = Float.parseFloat(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static double parseDouble(String value) {
        double result = 0.0;
        try {
            result = Double.parseDouble(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String nullToBlank(String value) {
        return value == null ? "" : value;
    }

    public static Object nullToBlank(Object value) {
        return value == null ? "" : value;
    }

    public static String toNull(String value) {
        return value == null || value.length() == 0 ? null : value;
    }

    public static String htmlConvert(String htmlStr) {
        if (htmlStr == null) {
            return "";
        }
        htmlStr = htmlStr.replaceAll("&", "&amp;");
        htmlStr = htmlStr.replaceAll(" ", "&nbsp;");
        htmlStr = htmlStr.replaceAll("\"", "&quot;");
        htmlStr = htmlStr.replaceAll("<", "&lt;");
        htmlStr = htmlStr.replaceAll(">", "&gt;");
        htmlStr = htmlStr.replaceAll("\r\n", "<br>");
        return htmlStr;
    }

    public static String toDate(String value) {
        return "to_date( '" + ECSideUtils.trimToDay(value) + "','yyyy-mm-dd' )";
    }

    public static String trimToDay(String value) {
        if (ECSideUtils.isEmpty(value)) {
            return "9999-01-01";
        }
        int idx = value.indexOf(" ");
        return idx == -1 ? value : value.substring(0, idx);
    }

    public static String preventImmit(String tmpStr) {
        if (tmpStr == null) {
            return "";
        }
        tmpStr = tmpStr.replaceAll("'", "''");
        return tmpStr;
    }

    public static String getFormatNowDateTime(String formatStr) {
        Calendar nowtime = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        return sdf.format(nowtime.getTime());
    }

    public static String getNowDate() {
        return ECSideUtils.getFormatNowDateTime("yyyy-MM-dd");
    }

    public static String getNowTime() {
        return ECSideUtils.getFormatNowDateTime("HH:mm:ss");
    }

    public static String getNowDateTime() {
        return ECSideUtils.getFormatNowDateTime("yyyy-MM-dd HH:mm:ss");
    }

    public static boolean isEmpty(String str) {
        return str == null || str.equals("");
    }

    public static Object nullToNew(Object obj, Object objNew) {
        return obj == null ? objNew : obj;
    }

    public static synchronized long getSEQSN(Connection conn, String SEQName) {
        long seqSN;
        block4: {
            long t1;
            seqSN = 0L;
            long startPoint = 1125983190000L;
            try {
                String query = "select " + SEQName + ".nextval from dual";
                Statement stmt = conn.createStatement();
                ResultSet rest = stmt.executeQuery(query);
                if (rest.next()) {
                    seqSN = rest.getInt(1);
                }
                break block4;
            }
            catch (Exception e) {
                t1 = System.currentTimeMillis();
            }
            while (t1 == System.currentTimeMillis()) {
            }
            seqSN = System.currentTimeMillis() - startPoint;
        }
        return seqSN;
    }

    public static String GBToUTF(String ostr) {
        try {
            return ostr == null ? ostr : new String(ostr.getBytes("GB2312"), "UTF-8");
        }
        catch (Exception e) {
            return ostr;
        }
    }

    public static String UTFToGB(String ostr) {
        try {
            return ostr == null ? ostr : new String(ostr.getBytes("UTF-8"), "GB2312");
        }
        catch (Exception e) {
            return ostr;
        }
    }

    public static String toHEX(String ostr) {
        StringBuffer rst = new StringBuffer();
        int i = 0;
        while (i < ostr.length()) {
            rst.append(Integer.toHexString(ostr.charAt(i)).toUpperCase());
            ++i;
        }
        return rst.toString();
    }

    public static String prepareXml(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        StringBuffer stringbuffer = new StringBuffer(s.length() + 50);
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if ('>' == c) {
                stringbuffer.append("&gt;");
            } else if ('<' == c) {
                stringbuffer.append("&lt;");
            } else if ('&' == c) {
                stringbuffer.append("&amp;");
            } else if (c == '\"') {
                stringbuffer.append("&quot;");
            } else if ('\'' == c) {
                stringbuffer.append("&apos;");
            } else {
                stringbuffer.append(c);
            }
            ++i;
        }
        return stringbuffer.toString();
    }

    public static int[] pageInfo(int totalRow, int pageSize, int pageNo) {
        int offset = 1;
        if (pageSize <= 0) {
            return new int[]{1, 0 + offset, totalRow};
        }
        int totalPage = (int)Math.ceil((double)totalRow / (double)pageSize);
        int startRow = pageSize * (pageNo - 1) + offset;
        int endRow = startRow + pageSize - 1;
        return new int[]{totalPage, startRow, endRow};
    }

    public static int[] pageInfo(Object totalRow, Object pageSize, Object pageNo) {
        try {
            int tr = Integer.parseInt((String)totalRow);
            int ps = Integer.parseInt((String)pageSize);
            int pn = Integer.parseInt((String)pageNo);
            return ECSideUtils.pageInfo(tr, ps, pn);
        }
        catch (Exception e) {
            return ECSideUtils.pageInfo(-1, -1, -1);
        }
    }

    public static int[] rowNoDesc(int totalRows, int startNo, int endNo) {
        int startNoNew = totalRows - endNo + 1;
        int endNoNew = totalRows - startNo + 1;
        return new int[]{startNoNew, endNoNew};
    }

    public static int[] pageInfoDesc(int totalRow, int pageSize, int pageNo) {
        int offset = 1;
        if (pageSize <= 0) {
            return new int[]{1, 0 + offset, totalRow};
        }
        int totalPage = (int)Math.ceil((double)totalRow / (double)pageSize);
        int endRow = totalRow - pageSize * (pageNo - 1);
        int startRow = endRow - pageSize + offset;
        return new int[]{totalPage, startRow, endRow};
    }

    public static String[] getValueAsArray(Object value) {
        if (value == null) {
            return new String[0];
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof List) {
            List valueList = (List)value;
            return valueList.toArray(new String[valueList.size()]);
        }
        return new String[]{value.toString()};
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (inString == null) {
            return null;
        }
        if (oldPattern == null || newPattern == null) {
            return inString;
        }
        StringBuffer sbuf = new StringBuffer();
        int pos = 0;
        int index = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sbuf.append(inString.substring(pos, index));
            sbuf.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sbuf.append(inString.substring(pos));
        return sbuf.toString();
    }

    public static String specialHTMLToShowTEXT(String html) {
        if (!StringUtils.isBlank((String)html)) {
            html = StringUtils.replace((String)html, (String)"&nbsp;", (String)" ");
            html = StringUtils.replace((String)html, (String)"&#160;", (String)" ");
            html = StringUtils.replace((String)html, (String)"&lt;", (String)"<");
            html = StringUtils.replace((String)html, (String)"&gt;", (String)">");
            html = StringUtils.replace((String)html, (String)"&quot;", (String)"\"");
            html = StringUtils.replace((String)html, (String)"&amp;", (String)"&");
        }
        return html;
    }

    public static String HTMLToTEXT(String html) {
        html = html.replaceAll("<([^<>]+)>", "");
        html = ECSideUtils.specialHTMLToShowTEXT(html);
        return html.replaceAll("<([^<>]+)>", "");
    }

    public static String escRex(String in) {
        return in.replaceAll("\\{", "\\\\{").replaceAll("\\}", "\\\\}");
    }

    public static String getAjaxBegin(String ectableId) {
        return "<!-- ECS_AJAX_ZONE_PREFIX__begin_ " + ectableId + "_ECS_AJAX_ZONE_SUFFIX -->";
    }

    public static String getAjaxEnd(String ectableId) {
        return "<!-- ECS_AJAX_ZONE_PREFIX_ _end_" + ectableId + "_ECS_AJAX_ZONE_SUFFIX -->";
    }

    public static String getTrHTML(List trList, TableModel model) {
        String extendTr = null;
        if (trList != null && trList.size() > 0) {
            StringBuffer eb = new StringBuffer();
            int i = 0;
            while (i < trList.size()) {
                Tr trBean = (Tr)trList.get(i);
                eb.append(Tr.buildTr(trBean, model));
                ++i;
            }
            extendTr = eb.toString();
        }
        return extendTr;
    }

    public static boolean isSearchMatchCaseIgnore(String value, String search) {
        value = value.toLowerCase().trim();
        search = search.toLowerCase().trim();
        return ECSideUtils.isSearchMatch(value, search);
    }

    public static boolean isSearchMatch(String value, String search) {
        if (search.startsWith("*") && search.endsWith("*") && StringUtils.contains((String)value, (String)search.substring(1, search.length() - 1))) {
            return true;
        }
        if (search.startsWith("*") && value.endsWith(StringUtils.replace((String)search, (String)"*", (String)""))) {
            return true;
        }
        if (search.endsWith("*") && value.startsWith(StringUtils.replace((String)search, (String)"*", (String)""))) {
            return true;
        }
        return value.equals(search);
    }

    public static String convertString(Object obj, String nullTo) {
        return obj == null ? nullTo : obj.toString();
    }

    public static String getDefaultSortSQL(Map map) {
        StringBuffer rs;
        block1: {
            rs = new StringBuffer();
            if (map == null || map.isEmpty()) break block1;
            Iterator itor = map.keySet().iterator();
            if (itor.hasNext()) {
                String field = (String)itor.next();
                String ord = (String)map.get(field);
                rs.append(" ORDER BY ").append((Object)field).append(" ").append(ord);
            }
        }
        return rs.toString();
    }
}

