/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.util;

import org.apache.commons.lang.StringUtils;

public class ExportViewUtils {
    public static final String BR = "\r\n";
    public static final char LF = '\n';
    public static final char CR = '\r';
    public static final char QUOTE = '\"';
    public static final char COMMA = ',';
    public static final char SPACE = ' ';
    public static final char TAB = '\t';
    public static final char POUND = '#';
    public static final char BACKSLASH = '\\';
    public static final char NULL = '\u0000';
    public static final String SPACE_C1 = "&nbsp;";
    public static final String SPACE_C2 = "&#160;";

    public static String parseXLS(String value) {
        if (StringUtils.isBlank((String)value)) {
            return "";
        }
        value = ExportViewUtils.replaceNonBreakingSpaces(value);
        return value;
    }

    public static String parsePDF(String value) {
        if (StringUtils.isBlank((String)value)) {
            return "";
        }
        value = ExportViewUtils.replaceNonBreakingSpaces(value);
        value = ExportViewUtils.escapeChars(value);
        return value;
    }

    public static String parseCSV(String content) {
        boolean needPrefix = true;
        boolean needTrim = true;
        boolean needQuote = false;
        if (content == null) {
            return needPrefix ? String.valueOf('\t') : "";
        }
        String string = content = needTrim ? content.trim() : content;
        if (content.indexOf("\r") != -1 || content.indexOf("\n") != -1 || content.indexOf(",") != -1) {
            needQuote = true;
        }
        content = StringUtils.replace((String)content, (String)SPACE_C1, (String)" ");
        content = StringUtils.replace((String)content, (String)SPACE_C2, (String)" ");
        content = StringUtils.replace((String)content, (String)"\"", (String)"\"\"");
        content = StringUtils.replace((String)content, (String)BR, (String)"\r");
        content = StringUtils.replace((String)content, (String)"\n", (String)"\r");
        String string2 = content = needPrefix ? String.valueOf('\t') + content : content;
        if (needQuote) {
            content = String.valueOf('\"') + content + '\"';
        }
        return content;
    }

    public static String replaceNonBreakingSpaces(String value) {
        if (StringUtils.isBlank((String)value)) {
            return "";
        }
        if (StringUtils.contains((String)value, (String)SPACE_C1)) {
            value = StringUtils.replace((String)value, (String)SPACE_C1, (String)"");
        }
        return value;
    }

    public static String escapeChars(String value) {
        if (StringUtils.isBlank((String)value)) {
            return "";
        }
        if (StringUtils.contains((String)value, (String)"&")) {
            value = StringUtils.replace((String)value, (String)"&", (String)"&#38;");
        }
        if (StringUtils.contains((String)value, (String)">")) {
            value = StringUtils.replace((String)value, (String)">", (String)"&gt;");
        }
        if (StringUtils.contains((String)value, (String)"<")) {
            value = StringUtils.replace((String)value, (String)"<", (String)"&lt;");
        }
        return value;
    }
}

