/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.ecside.core.context.HttpServletRequestContext;
import org.ecside.resource.MimeUtils;
import org.ecside.table.limit.Limit;
import org.ecside.table.limit.TableLimit;
import org.ecside.table.limit.TableLimitFactory;
import org.ecside.util.ECSideUtils;

public class RequestUtils {
    public static String successfulInfo(HttpServletRequest request) {
        return RequestUtils.successfulInfo(request, null, null);
    }

    public static String failedInfo(HttpServletRequest request) {
        return RequestUtils.failedInfo(request, null, null);
    }

    public static String successfulInfo(HttpServletRequest request, String otherMessage) {
        return RequestUtils.successfulInfo(request, null, otherMessage);
    }

    public static String failedInfo(HttpServletRequest request, String otherMessage) {
        return RequestUtils.failedInfo(request, null, otherMessage);
    }

    public static String successfulInfo(HttpServletRequest request, String tableIdT, String otherMessage) {
        return RequestUtils.successfulOrFailedInfo("Success", RequestUtils.getTableId(request, tableIdT), otherMessage);
    }

    public static String failedInfo(HttpServletRequest request, String tableIdT, String otherMessage) {
        return RequestUtils.successfulOrFailedInfo("Fail", RequestUtils.getTableId(request, tableIdT), otherMessage);
    }

    public static String successfulOrFailedInfo(String flag, String tableIdT, String otherMessage) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(tableIdT).append("\n").append(flag);
        if (StringUtils.isNotBlank((String)otherMessage)) {
            sbuf.append("\n").append(otherMessage);
        }
        return sbuf.toString();
    }

    public static String getTableId(HttpServletRequest request) {
        return RequestUtils.getTableId(request, null);
    }

    public static int getTotalRowsFromRequest(HttpServletRequest request) {
        return RequestUtils.getTotalRowsFromRequest(request, null);
    }

    public static int[] getRowStartEnd(HttpServletRequest request, int totalRows, int defaultPageSize) {
        return RequestUtils.getRowStartEnd(request, null, totalRows, defaultPageSize);
    }

    public static int[] getRowStartEnd(HttpServletRequest request, int totalRows, int defaultPageSize, int offset) {
        return RequestUtils.getRowStartEnd(request, null, totalRows, defaultPageSize, offset);
    }

    public static String getTableId(HttpServletRequest request, String cTableId) {
        if (cTableId != null) {
            return cTableId;
        }
        String tableId = request.getParameter("ec_i");
        if (tableId == null) {
            tableId = "ec";
        }
        return tableId;
    }

    public static int getTotalRowsFromRequest(HttpServletRequest request, String cTableId) {
        int totalRows = -1;
        String tableId = RequestUtils.getTableId(request, cTableId);
        tableId = tableId == null ? "" : String.valueOf(tableId) + "_";
        Integer totalRowsI = (Integer)request.getAttribute(String.valueOf(tableId) + "totalRows");
        try {
            if (totalRowsI != null) {
                totalRows = totalRowsI;
            } else {
                String totalRowsS = request.getParameter(String.valueOf(tableId) + "totalrows");
                totalRows = Integer.parseInt(totalRowsS);
            }
        }
        catch (Exception e) {
            totalRows = -1;
        }
        totalRows = totalRows < 0 ? -1 : totalRows;
        return totalRows;
    }

    public static int[] getRowStartEnd(HttpServletRequest request, String cTableId, int totalRows, int defaultPageSize) {
        int offset = 0;
        return RequestUtils.getRowStartEnd(request, cTableId, totalRows, defaultPageSize, offset);
    }

    public static int[] getRowStartEnd(HttpServletRequest request, String cTableId, int totalRows, int defaultPageSize, int offset) {
        Limit limit = RequestUtils.getLimit(request, cTableId, totalRows, defaultPageSize);
        return new int[]{limit.getRowStart() + offset, limit.getRowEnd() + offset};
    }

    public static int getPageNo(HttpServletRequest request) {
        int pageNo = -1;
        HttpServletRequestContext context = new HttpServletRequestContext(request);
        String tableId = request.getParameter("ec_i");
        if (tableId == null) {
            tableId = "ec";
        }
        TableLimitFactory limitFactory = new TableLimitFactory(context, tableId);
        TableLimit limit = new TableLimit(limitFactory);
        pageNo = limit.getPage();
        return pageNo;
    }

    public static Limit getLimit(HttpServletRequest request) {
        return RequestUtils.getLimit(request, null);
    }

    public static Limit getLimit(HttpServletRequest request, String cTableId) {
        HttpServletRequestContext context = new HttpServletRequestContext(request);
        String tableId = RequestUtils.getTableId(request, cTableId);
        TableLimitFactory limitFactory = new TableLimitFactory(context, tableId);
        TableLimit limit = new TableLimit(limitFactory);
        return limit;
    }

    public static void initLimit(HttpServletRequest request, int totalRows, int defaultPageSize) {
        RequestUtils.initLimit(request, null, totalRows, defaultPageSize);
    }

    public static void initLimit(HttpServletRequest request, String cTableId, int totalRows, int defaultPageSize) {
        RequestUtils.getLimit(request, cTableId).setRowAttributes(totalRows, defaultPageSize);
    }

    public static Limit getLimit(HttpServletRequest request, int totalRows, int defaultPageSize) {
        return RequestUtils.getLimit(request, null, totalRows, defaultPageSize);
    }

    public static Limit getLimit(HttpServletRequest request, String cTableId, int totalRows, int defaultPageSize) {
        Limit limit = RequestUtils.getLimit(request, cTableId);
        limit.setRowAttributes(totalRows, defaultPageSize);
        return limit;
    }

    public static void setTotalRows(HttpServletRequest request, int totalRows) {
        RequestUtils.setTotalRows(request, null, totalRows);
    }

    public static void setTotalRows(HttpServletRequest request, String cTableId, int totalRows) {
        String tableId = RequestUtils.getTableId(request, cTableId);
        tableId = tableId == null ? "" : String.valueOf(tableId) + "_";
        request.setAttribute(String.valueOf(tableId) + "totalRows", (Object)new Integer(totalRows));
    }

    public static int getCurrentRowsDisplayed(HttpServletRequest request) {
        String tableId = request.getParameter("ec_i");
        String currentRowsDisplayed = request.getParameter(String.valueOf(tableId) + "_" + "crd");
        int crd = 0;
        if (StringUtils.isNotBlank((String)currentRowsDisplayed)) {
            try {
                crd = Integer.parseInt(currentRowsDisplayed);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return crd;
    }

    public static boolean isAJAXRequest(ServletRequest servletRequest) {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        return Boolean.TRUE.toString().equalsIgnoreCase(request.getHeader("isAjaxRequest")) || Boolean.TRUE.toString().equalsIgnoreCase(request.getHeader("useAjaxPrep"));
    }

    public static String encodeFileName(HttpServletRequest request, String fileName) throws UnsupportedEncodingException {
        String agent = request.getHeader("USER-AGENT");
        return ECSideUtils.encodeFileName(fileName, agent);
    }

    public static boolean isExported(HttpServletRequest request) {
        return StringUtils.isNotBlank((String)RequestUtils.getExportTableId(request));
    }

    public static String getExportTableId(HttpServletRequest request) {
        return request.getParameter("eti");
    }

    public static String getExportFileName(HttpServletRequest request) {
        return RequestUtils.getExportFileName(request, null);
    }

    public static String getExportFileName(HttpServletRequest request, String cTableId) {
        String tableId = RequestUtils.getTableId(request, cTableId);
        if (StringUtils.isNotBlank((String)tableId)) {
            String exportFileNameStr = String.valueOf(tableId) + "_" + "efn";
            String exportFileName = request.getParameter(exportFileNameStr);
            return exportFileName;
        }
        return null;
    }

    public static void beforeExport(HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException {
        RequestUtils.beforeExport(request, response, RequestUtils.getExportFileName(request));
    }

    public static void beforeExport(HttpServletRequest request, HttpServletResponse response, String exportFileName) throws UnsupportedEncodingException {
        String mimeType = MimeUtils.getFileMimeType(exportFileName = RequestUtils.encodeFileName(request, exportFileName));
        if (StringUtils.isNotBlank((String)mimeType)) {
            response.setContentType(mimeType);
        }
        response.setHeader("Content-Disposition", "attachment;filename=\"" + exportFileName + "\"");
        response.setHeader("Content-Transfer-Encoding", "binary");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        response.setDateHeader("Expires", System.currentTimeMillis() + 1000L);
    }

    public static void afterExport(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.getOutputStream().flush();
        response.getOutputStream().close();
    }
}

