/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.view;

import org.ecside.core.TableModel;
import org.ecside.core.bean.Column;
import org.ecside.util.HtmlBuilder;
import org.ecside.view.View;
import org.ecside.view.html.CalcBuilder;
import org.ecside.view.html.FormBuilder;
import org.ecside.view.html.RowBuilder;
import org.ecside.view.html.TableBuilder;

public abstract class AbstractHtmlView
implements View {
    private HtmlBuilder html;
    private TableModel model;
    private FormBuilder formBuilder;
    private boolean bufferView;
    private TableBuilder tableBuilder;
    private RowBuilder rowBuilder;
    private CalcBuilder calcBuilder;

    protected HtmlBuilder getHtmlBuilder() {
        return this.html;
    }

    protected TableModel getTableModel() {
        return this.model;
    }

    protected TableBuilder getTableBuilder() {
        return this.tableBuilder;
    }

    protected void setTableBuilder(TableBuilder tableBuilder) {
        this.tableBuilder = tableBuilder;
    }

    public RowBuilder getRowBuilder() {
        return this.rowBuilder;
    }

    protected void setRowBuilder(RowBuilder rowBuilder) {
        this.rowBuilder = rowBuilder;
    }

    public CalcBuilder getCalcBuilder() {
        return this.calcBuilder;
    }

    protected void setCalcBuilder(CalcBuilder calcBuilder) {
        this.calcBuilder = calcBuilder;
    }

    public final void beforeBody(TableModel model) {
        this.model = model;
        this.bufferView = model.getTable().isBufferView();
        this.html = this.bufferView ? new HtmlBuilder() : new HtmlBuilder(model.getContext().getWriter());
        this.formBuilder = new FormBuilder(this.html, model);
        this.init(this.html, model);
        this.formBuilder.formStart();
        this.tableBuilder.themeStart();
        this.beforeBodyInternal(model);
    }

    public void body(TableModel model, Column column) {
        if (column.isFirstColumn()) {
            this.rowBuilder.rowStart();
        }
        this.html.append(column.getCellDisplay());
        if (column.isLastColumn()) {
            this.rowBuilder.rowEnd();
        }
    }

    public final Object afterBody(TableModel model) {
        this.afterBodyInternal(model);
        this.tableBuilder.themeEnd();
        this.formBuilder.formEnd();
        if (this.bufferView) {
            return this.html.toString();
        }
        return "";
    }

    protected void init(HtmlBuilder html, TableModel model) {
        this.setTableBuilder(new TableBuilder(html, model));
        this.setRowBuilder(new RowBuilder(html, model));
        this.setCalcBuilder(new CalcBuilder(model));
    }

    protected abstract void beforeBodyInternal(TableModel var1);

    protected abstract void afterBodyInternal(TableModel var1);
}

