/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.view;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.ecside.core.TableModel;
import org.ecside.core.bean.Column;
import org.ecside.core.bean.Export;
import org.ecside.table.calc.CalcResult;
import org.ecside.table.calc.CalcUtils;
import org.ecside.util.ExportViewUtils;
import org.ecside.util.ExtremeUtils;
import org.ecside.view.View;

public class CsvView
implements View {
    public static final String DELIMITER = "delimiter";
    static final String DEFAULT_DELIMITER = ",";
    private ByteArrayOutputStream outputStream;
    private ByteArrayOutputStream outputStreamOut;
    private StringBuffer rowBuffer = null;
    private PrintWriter out = null;
    private String delimiter;

    public void beforeBody(TableModel model) {
        this.outputStreamOut = this.outputStream = new ByteArrayOutputStream();
        this.out = new PrintWriter(this.outputStream);
        Export export = model.getExportHandler().getCurrentExport();
        this.delimiter = export.getAttributeAsString(DELIMITER);
        List columns = model.getColumnHandler().getHeaderColumns();
        if (StringUtils.isBlank((String)this.delimiter)) {
            this.delimiter = DEFAULT_DELIMITER;
        }
        boolean isFirstColumn = true;
        this.rowBuffer = new StringBuffer();
        Iterator iter = columns.iterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            String value = ExportViewUtils.parseCSV(column.getCellDisplay());
            if (!isFirstColumn) {
                this.rowBuffer.append(this.delimiter);
            }
            this.rowBuffer.append(value);
            isFirstColumn = false;
        }
        if (columns.size() > 0) {
            this.rowBuffer.append("\r\n");
            this.writeToOutputStream(this.rowBuffer.toString());
        }
    }

    public void body(TableModel model, Column column) {
        String value = ExportViewUtils.parseCSV(column.getCellDisplay());
        this.rowBuffer.append(value);
        if (column.isLastColumn()) {
            this.rowBuffer.append("\r\n");
            this.writeToOutputStream(this.rowBuffer.toString());
        } else {
            this.rowBuffer.append(this.delimiter);
        }
    }

    public Object afterBody(TableModel model) {
        this.totals(model);
        this.out.flush();
        this.out.close();
        return this.outputStreamOut;
    }

    public void totals(TableModel model) {
        this.rowBuffer = new StringBuffer();
        Column firstCalcColumn = model.getColumnHandler().getFirstCalcColumn();
        if (firstCalcColumn != null) {
            int rows = firstCalcColumn.getCalc().length;
            int i = 0;
            while (i < rows) {
                Iterator iter = model.getColumnHandler().getColumns().iterator();
                while (iter.hasNext()) {
                    Column column = (Column)iter.next();
                    if (column.isFirstColumn()) {
                        String calcTitle = CalcUtils.getFirstCalcColumnTitleByPosition(model, i);
                        this.rowBuffer.append(ExportViewUtils.parseCSV(calcTitle));
                        continue;
                    }
                    this.rowBuffer.append(this.delimiter);
                    if (column.isCalculated()) {
                        CalcResult calcResult = CalcUtils.getCalcResultsByPosition(model, column, i);
                        Number value = calcResult.getValue();
                        if (value != null) {
                            if (StringUtils.isNotBlank((String)column.getFormat())) {
                                this.rowBuffer.append(ExportViewUtils.parseCSV(ExtremeUtils.formatNumber(column.getFormat(), value, model.getLocale())));
                                continue;
                            }
                            this.rowBuffer.append(ExportViewUtils.parseCSV(value.toString()));
                            continue;
                        }
                        this.rowBuffer.append(ExportViewUtils.parseCSV(""));
                        continue;
                    }
                    this.rowBuffer.append(ExportViewUtils.parseCSV(""));
                }
                this.rowBuffer.append("\r\n");
                this.writeToOutputStream(this.rowBuffer.toString());
                ++i;
            }
        }
    }

    public void writeToOutputStream(String rowContent) {
        this.out.print(rowContent);
        this.rowBuffer = new StringBuffer();
    }
}

