/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.view;

import org.apache.commons.lang.StringUtils;
import org.ecside.core.TableModel;
import org.ecside.core.bean.Column;
import org.ecside.core.bean.Table;
import org.ecside.table.tool.ExportTool;
import org.ecside.table.tool.ExtendTool;
import org.ecside.table.tool.ToolBarBuilder;
import org.ecside.util.HtmlBuilder;
import org.ecside.view.View;
import org.ecside.view.html.CalcBuilder;
import org.ecside.view.html.FormBuilder;
import org.ecside.view.html.RowBuilder;
import org.ecside.view.html.TableBuilder;

public class DefaultHtmlView
implements View {
    public static String HEAD_ZONE_ID = "headZone";
    public static String HEAD_TABLE_ID = "headTable";
    public static String HEAD_THEAD_ID = "headThead";
    public static String BODY_ZONE_ID = "bodyZone";
    public static String BODY_TABLE_ID = "bodyTable";
    public static String BODY_THEAD_ID = "bodyThead";
    public static String BODY_TBODY_ID = "bodyTbody";
    public static String BODY_TFOOT_ID = "bodyTfoot";
    public static String FOOT_ZONE_ID = "footZone";
    public static String FOOT_TABLE_ID = "footTable";
    public static String FOOT_THEAD_ID = "footThead";
    public static String FOOT_TBODY_ID = "footTbody";
    public static String FOOT_TFOOT_ID = "footTfoot";
    protected HtmlBuilder html;
    protected TableBuilder tableBuilder;
    protected RowBuilder rowBuilder;
    protected FormBuilder formBuilder;
    protected CalcBuilder calcBuilder;
    protected Table table;
    protected ToolBarBuilder toolBarBuilder = null;
    protected String toolbarLocation = null;
    protected String alwaysShowExtend = null;
    protected boolean bufferView;
    protected boolean showToolBar = false;
    protected String height = null;
    protected boolean splitTable = false;
    protected boolean isClassic = false;

    protected HtmlBuilder getHtmlBuilder() {
        return this.html;
    }

    protected CalcBuilder getCalcBuilder() {
        return this.calcBuilder;
    }

    protected FormBuilder getFormBuilder() {
        return this.formBuilder;
    }

    protected RowBuilder getRowBuilder() {
        return this.rowBuilder;
    }

    protected TableBuilder getTableBuilder() {
        return this.tableBuilder;
    }

    public void init(TableModel model) {
        this.table = model.getTable();
        this.bufferView = this.table.isBufferView();
        this.html = this.bufferView ? new HtmlBuilder() : new HtmlBuilder(model.getContext().getWriter());
        this.tableBuilder = new TableBuilder(this.html, model);
        this.rowBuilder = new RowBuilder(this.html, model);
        this.calcBuilder = new CalcBuilder(model);
        this.formBuilder = new FormBuilder(this.html, model);
        this.toolBarBuilder = new ToolBarBuilder(this.html, model, this.table.getToolbarContent());
        this.toolbarLocation = this.table.getToolbarLocation();
        this.alwaysShowExtend = this.table.getAlwaysShowExtend();
        this.height = this.table.getHeight();
        this.isClassic = this.table.isClassic();
    }

    public void beforeBody(TableModel model) {
        this.init(model);
        this.formBuilder.formStart();
        this.tableBuilder.title();
        String extendBarTop = (String)model.getTable().getAttribute("ExtendBarTop");
        if (StringUtils.isNotBlank((String)extendBarTop)) {
            this.html.div().styleClass("extendBarTop").close();
            this.html.append(extendBarTop);
            this.html.divEnd();
        }
        this.toolbar(model, "top");
        this.extendTool(model, "top");
        String prefixWithTableId = model.getTableHandler().prefixWithTableId();
        this.html.newline();
        if (!this.isClassic) {
            this.html.div().styleClass(HEAD_ZONE_ID);
            this.html.id(String.valueOf(prefixWithTableId) + HEAD_ZONE_ID).close();
        }
        if (!this.isClassic) {
            this.tableBuilder.tableStartH();
        } else {
            this.tableBuilder.tableStart();
        }
        this.tableBuilder.theadStart();
        String extendRowTop = (String)model.getTable().getAttribute("ExtendRowTop");
        boolean showHeader = model.getTable().isShowHeader();
        boolean hasExtendRowTop = StringUtils.isNotBlank((String)extendRowTop);
        if (showHeader) {
            if (hasExtendRowTop) {
                this.tableBuilder.headerHideRow();
                this.html.append(extendRowTop);
            }
            this.tableBuilder.headerRow();
        } else if (!showHeader && this.isClassic) {
            if (hasExtendRowTop) {
                this.html.append(extendRowTop);
            }
            this.tableBuilder.headerHideRow();
        } else if (!showHeader && !this.isClassic) {
            this.tableBuilder.headerHideRow();
            if (hasExtendRowTop) {
                this.html.append(extendRowTop);
            }
        }
        this.tableBuilder.theadEnd();
        if (!this.isClassic) {
            this.html.tableEnd(0);
            this.html.divEnd();
            this.html.newline();
            String sWidth = this.table.getWidth();
            if (StringUtils.isBlank((String)sWidth)) {
                sWidth = "100%";
            }
            if (sWidth.indexOf("px") == -1 && sWidth.indexOf("%") == -1) {
                sWidth = String.valueOf(sWidth) + "px";
            }
            String sHeight = StringUtils.isNotBlank((String)this.height) ? "height:" + this.height : "";
            this.html.div().style("overflow:auto;width:" + sWidth + ";" + sHeight);
            this.html.styleClass(BODY_ZONE_ID).id(String.valueOf(prefixWithTableId) + BODY_ZONE_ID).close();
            this.tableBuilder.tableStart();
        }
        this.tableBuilder.tbodyStart();
        String extendRowBefore = (String)model.getTable().getAttribute("ExtendRowBefore");
        if (StringUtils.isNotBlank((String)extendRowBefore)) {
            if (!this.isClassic) {
                this.tableBuilder.headerHideRow();
            }
            this.html.append(extendRowBefore);
        } else {
            int totalRows = model.getLimit().getTotalRows();
            if (totalRows < 1 && !this.isClassic) {
                this.tableBuilder.bodyHideRow();
            }
        }
    }

    public Object afterBody(TableModel model) {
        boolean hasCalc = false;
        if (new Integer(model.getLimit().getTotalRows()) > 0) {
            hasCalc = this.calcBuilder.defaultCalcLayout();
        }
        this.html.append(this.calcBuilder.getHtmlBuilder());
        String extendRowAfter = (String)model.getTable().getAttribute("ExtendRowAfter");
        if (StringUtils.isNotBlank((String)extendRowAfter)) {
            this.html.append(extendRowAfter);
        }
        if (hasCalc) {
            this.html.tfootEnd(1);
        } else {
            this.tableBuilder.tbodyEnd();
        }
        this.tableBuilder.tableEnd();
        ExportTool.buildExportIframe(this.html, model);
        if (!this.isClassic) {
            this.html.divEnd();
            this.html.newline();
        }
        this.toolbar(model, "bottom");
        this.extendTool(model, "bottom");
        this.formBuilder.formEnd();
        this.tableBuilder.buildWaitingBar();
        this.tableBuilder.buildScript();
        if (this.bufferView) {
            return this.html.toString();
        }
        return "";
    }

    private void extendTool(TableModel model, String pos) {
        if (this.showToolBar || !pos.equalsIgnoreCase(this.alwaysShowExtend) && !"both".equalsIgnoreCase(this.alwaysShowExtend)) {
            return;
        }
        ExtendTool.buildExtendTool(this.html, model);
    }

    protected void toolbar(TableModel model, String pos) {
        if (!pos.equalsIgnoreCase(this.toolbarLocation) && !"both".equalsIgnoreCase(this.toolbarLocation)) {
            return;
        }
        String extendBarBefore = (String)model.getTable().getAttribute("ExtendBarBefore");
        if (StringUtils.isNotBlank((String)extendBarBefore)) {
            this.html.div().styleClass("extendBarBefore").close();
            this.html.append(extendBarBefore);
            this.html.divEnd();
        }
        this.toolBarBuilder.buildToolBar();
        String extendBarAfter = (String)model.getTable().getAttribute("ExtendBarAfter");
        if (StringUtils.isNotBlank((String)extendBarAfter)) {
            this.html.div().styleClass("extendBarAfter").close();
            this.html.append(extendBarAfter);
            this.html.divEnd();
        }
        this.showToolBar = true;
    }

    public void body(TableModel model, Column column) {
        if (column.isFirstColumn()) {
            this.rowBuilder.rowStart();
            this.html.newline();
        }
        this.html.append(column.getCellDisplay());
        this.html.newline();
        if (column.isLastColumn()) {
            this.rowBuilder.rowEnd();
        }
    }
}

