/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.view;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.ecside.core.TableModel;
import org.ecside.core.bean.Column;
import org.ecside.core.bean.Export;
import org.ecside.table.calc.CalcResult;
import org.ecside.table.calc.CalcUtils;
import org.ecside.util.ExportViewUtils;
import org.ecside.util.ExtremeUtils;
import org.ecside.view.View;

public class PdfView
implements View {
    public static final String FONT = "exportPdf.font";
    public static final String HEADER_BACKGROUND_COLOR = "headerBackgroundColor";
    public static final String HEADER_TITLE = "headerTitle";
    public static final String HEADER_COLOR = "headerColor";
    public static final int COLUMN_T_WIDTH = 10;
    private StringBuffer xlsfo = new StringBuffer();
    private String font;

    public void beforeBody(TableModel model) {
        this.font = model.getPreferences().getPreference(FONT);
        this.xlsfo.append(this.startRoot());
        this.xlsfo.append(this.regionBefore(model));
        this.xlsfo.append(this.regionAfter());
        this.xlsfo.append(this.columnDefinitions(model));
        this.xlsfo.append(this.header(model));
        this.xlsfo.append(" <fo:table-body> ");
    }

    public void body(TableModel model, Column column) {
        if (column.isFirstColumn()) {
            this.xlsfo.append(" <fo:table-row> ");
        }
        String value = ExportViewUtils.parsePDF(column.getCellDisplay());
        this.xlsfo.append(" <fo:table-cell language=\"zh\" wrap-option=\"wrap\"  border=\"solid silver .5px\" display-align=\"center\" padding=\"3pt\"> ");
        this.xlsfo.append(" <fo:block language=\"zh\" wrap-option=\"wrap\" " + this.getFont() + ">" + value + "</fo:block> ");
        this.xlsfo.append(" </fo:table-cell> ");
        if (column.isLastColumn()) {
            this.xlsfo.append(" </fo:table-row> ");
        }
    }

    public Object afterBody(TableModel model) {
        if (model.getLimit().getTotalRows() != 0) {
            this.xlsfo.append(this.totals(model));
        }
        this.xlsfo.append(" </fo:table-body> ");
        this.xlsfo.append(this.endRoot());
        return this.xlsfo.toString();
    }

    public String startRoot() {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<fo:root xmlns:fo=\"http://www.w3.org/1999/XSL/Format\">");
        sb.append(" <fo:layout-master-set> ");
        sb.append(" <fo:simple-page-master master-name=\"simple\" ");
        sb.append(" page-height=\"8.5in\" ");
        sb.append(" page-width=\"11in\" ");
        sb.append(" margin-top=\".5in\" ");
        sb.append(" margin-bottom=\".25in\" ");
        sb.append(" margin-left=\".5in\" ");
        sb.append(" margin-right=\".5in\"> ");
        sb.append(" <fo:region-body margin-top=\".5in\" margin-bottom=\".25in\"/> ");
        sb.append(" <fo:region-before extent=\".5in\"/> ");
        sb.append(" <fo:region-after extent=\".25in\"/> ");
        sb.append(" </fo:simple-page-master> ");
        sb.append(" </fo:layout-master-set> ");
        sb.append(" <fo:page-sequence master-reference=\"simple\" initial-page-number=\"1\" language=\"zh\"> ");
        return sb.toString();
    }

    public String regionBefore(TableModel model) {
        StringBuffer sb = new StringBuffer();
        Export export = model.getExportHandler().getCurrentExport();
        String headerColor = export.getAttributeAsString(HEADER_COLOR);
        if (StringUtils.isBlank((String)headerColor)) {
            headerColor = "#000000";
        }
        sb.append(" <fo:static-content flow-name=\"xsl-region-before\"> ");
        String title = export.getAttributeAsString(HEADER_TITLE);
        if (StringUtils.isBlank((String)title)) {
            title = model.getTable().getTitle();
        }
        sb.append(" <fo:block space-after.optimum=\"15pt\" color=\"" + headerColor + "\" font-size=\"17pt\" font-family=\"" + this.getHeadFont() + "'Times'\">" + title + "</fo:block> ");
        sb.append(" </fo:static-content> ");
        return sb.toString();
    }

    public String regionAfter() {
        StringBuffer sb = new StringBuffer();
        sb.append(" <fo:static-content flow-name=\"xsl-region-after\" display-align=\"after\"> ");
        sb.append(" <fo:block text-align=\"end\">Page <fo:page-number/></fo:block> ");
        sb.append(" </fo:static-content> ");
        return sb.toString();
    }

    public String columnDefinitions(TableModel model) {
        StringBuffer sb = new StringBuffer();
        sb.append(" <fo:flow flow-name=\"xsl-region-body\"> ");
        sb.append(" <fo:block" + this.getFont() + ">");
        sb.append(" <fo:table table-layout=\"fixed\" font-size=\"10pt\"> ");
        double columnCount = model.getColumnHandler().columnCount();
        double colwidth = 10.0 / columnCount;
        int i = 1;
        while ((double)i <= columnCount) {
            sb.append(" <fo:table-column column-number=\"" + i + "\" column-width=\"" + colwidth + "in\"/> ");
            ++i;
        }
        return sb.toString();
    }

    public String header(TableModel model) {
        StringBuffer sb = new StringBuffer();
        Export export = model.getExportHandler().getCurrentExport();
        String headerColor = export.getAttributeAsString(HEADER_COLOR);
        String headerBackgroundColor = export.getAttributeAsString(HEADER_BACKGROUND_COLOR);
        if (StringUtils.isBlank((String)headerColor)) {
            headerColor = "#000000";
        }
        if (StringUtils.isBlank((String)headerBackgroundColor)) {
            headerBackgroundColor = "#cccccc";
        }
        sb.append(" <fo:table-header background-color=\"" + headerBackgroundColor + "\" color=\"" + headerColor + "\"> ");
        sb.append(" <fo:table-row> ");
        List columns = model.getColumnHandler().getHeaderColumns();
        Iterator iter = columns.iterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            String title = column.getCellDisplay();
            sb.append(" <fo:table-cell border=\"solid silver .5px\" text-align=\"center\" display-align=\"center\" padding=\"3pt\"> ");
            sb.append(" <fo:block" + this.getFont() + ">" + title + "</fo:block> ");
            sb.append(" </fo:table-cell> ");
        }
        sb.append(" </fo:table-row> ");
        sb.append(" </fo:table-header> ");
        return sb.toString();
    }

    public String endRoot() {
        StringBuffer sb = new StringBuffer();
        sb.append(" </fo:table> ");
        sb.append(" </fo:block> ");
        sb.append(" </fo:flow> ");
        sb.append(" </fo:page-sequence> ");
        sb.append(" </fo:root> ");
        return sb.toString();
    }

    protected String getFont() {
        return this.font == null ? "" : " font-family=\"" + this.font + "\"";
    }

    protected String getHeadFont() {
        return this.font == null ? "" : String.valueOf(this.font) + ",";
    }

    public StringBuffer totals(TableModel model) {
        Column firstCalcColumn;
        StringBuffer sb = new StringBuffer();
        Export export = model.getExportHandler().getCurrentExport();
        String headerColor = export.getAttributeAsString(HEADER_COLOR);
        String headerBackgroundColor = export.getAttributeAsString(HEADER_BACKGROUND_COLOR);
        if (StringUtils.isBlank((String)headerColor)) {
            headerColor = "#000000";
        }
        if (StringUtils.isBlank((String)headerBackgroundColor)) {
            headerBackgroundColor = "#cccccc";
        }
        if ((firstCalcColumn = model.getColumnHandler().getFirstCalcColumn()) != null) {
            int rows = firstCalcColumn.getCalc().length;
            int i = 0;
            while (i < rows) {
                sb.append("<fo:table-row>");
                Iterator iter = model.getColumnHandler().getColumns().iterator();
                while (iter.hasNext()) {
                    Column column = (Column)iter.next();
                    if (column.isFirstColumn()) {
                        String calcTitle = CalcUtils.getFirstCalcColumnTitleByPosition(model, i);
                        sb.append(" <fo:table-cell border=\"solid silver .5px\" text-align=\"center\" display-align=\"center\" padding=\"3pt\" background-color=\"");
                        sb.append(String.valueOf(headerBackgroundColor) + "\" color=\"" + headerColor + "\">");
                        sb.append(" <fo:block " + this.getFont() + ">" + calcTitle);
                        sb.append(" </fo:block></fo:table-cell> ");
                        continue;
                    }
                    if (column.isCalculated()) {
                        sb.append(" <fo:table-cell border=\"solid silver .5px\" text-align=\"center\" display-align=\"center\" padding=\"3pt\" background-color=\"");
                        sb.append(String.valueOf(headerBackgroundColor) + "\" color=\"" + headerColor + "\"> ");
                        sb.append(" <fo:block " + this.getFont() + ">");
                        CalcResult calcResult = CalcUtils.getCalcResultsByPosition(model, column, i);
                        Number value = calcResult.getValue();
                        if (value != null) {
                            sb.append(ExtremeUtils.formatNumber(column.getFormat(), value, model.getLocale()));
                        } else {
                            sb.append("n/a");
                        }
                        sb.append("</fo:block> ");
                    } else {
                        sb.append(" <fo:table-cell border=\"solid silver .5px\" text-align=\"center\" display-align=\"center\" padding=\"3pt\" background-color=\"");
                        sb.append(String.valueOf(headerBackgroundColor) + "\" color=\"" + headerColor + "\"> ");
                        sb.append(" <fo:block " + this.getFont() + ">");
                        sb.append(" ");
                        sb.append("</fo:block> ");
                    }
                    sb.append(" </fo:table-cell> ");
                }
                sb.append("</fo:table-row>");
                ++i;
            }
        }
        return sb;
    }
}

