/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.view;

import org.apache.commons.lang.StringUtils;
import org.ecside.core.TableModel;
import org.ecside.core.bean.Column;
import org.ecside.core.bean.Table;
import org.ecside.util.HtmlBuilder;
import org.ecside.view.View;
import org.ecside.view.html.CalcBuilder;
import org.ecside.view.html.FormBuilder;
import org.ecside.view.html.RowBuilder;
import org.ecside.view.html.TableBuilder;

public class PrintView
implements View {
    protected Table table;
    private HtmlBuilder html;
    private TableBuilder tableBuilder;
    private RowBuilder rowBuilder;
    private FormBuilder formBuilder;
    private CalcBuilder calcBuilder;
    boolean bufferView;

    protected HtmlBuilder getHtmlBuilder() {
        return this.html;
    }

    protected CalcBuilder getCalcBuilder() {
        return this.calcBuilder;
    }

    protected FormBuilder getFormBuilder() {
        return this.formBuilder;
    }

    protected RowBuilder getRowBuilder() {
        return this.rowBuilder;
    }

    protected TableBuilder getTableBuilder() {
        return this.tableBuilder;
    }

    public void themeStart(TableModel model) {
        this.html.newline();
        String theme = String.valueOf(model.getTable().getTheme()) + "_pring";
        this.html.div().styleClass(theme);
        this.html.close();
    }

    public void tableTitle(TableModel model) {
    }

    public void tableStart(TableModel model) {
    }

    public void theadStart(TableModel model) {
    }

    public void theadEnd(TableModel model) {
    }

    public void tbodyStart(TableModel model) {
    }

    public void tbodyEnd(TableModel model) {
    }

    public void tableEnd(TableModel model) {
    }

    public void themeEnd(TableModel model) {
        this.html.newline();
        this.html.divEnd();
    }

    public void formEnd(TableModel model) {
    }

    public void init(TableModel model) {
        this.table = model.getTable();
        this.bufferView = this.table.isBufferView();
        this.html = this.bufferView ? new HtmlBuilder() : new HtmlBuilder(model.getContext().getWriter());
        this.tableBuilder = new TableBuilder(this.html, model);
        this.rowBuilder = new RowBuilder(this.html, model);
        this.calcBuilder = new CalcBuilder(model);
        this.formBuilder = new FormBuilder(this.html, model);
    }

    public void beforeBody(TableModel model) {
        this.init(model);
        this.formBuilder.formStart();
        this.tableBuilder.title();
        this.html.newline();
        this.tableBuilder.tableStart();
        this.tableBuilder.theadStart();
        String extendRowTop = (String)model.getTable().getAttribute("ExtendRowTop");
        boolean showHeader = model.getTable().isShowHeader();
        boolean hasExtendRowTop = StringUtils.isNotBlank((String)extendRowTop);
        if (showHeader) {
            if (hasExtendRowTop) {
                this.tableBuilder.headerHideRow();
                this.html.append(extendRowTop);
            }
            this.tableBuilder.headerRow();
        } else if (!showHeader) {
            if (hasExtendRowTop) {
                this.html.append(extendRowTop);
            }
            this.tableBuilder.headerHideRow();
        }
        this.tableBuilder.theadEnd();
        this.tableBuilder.tbodyStart();
        String extendRowBefore = (String)model.getTable().getAttribute("ExtendRowBefore");
        if (StringUtils.isNotBlank((String)extendRowBefore)) {
            this.html.append(extendRowBefore);
        }
    }

    public Object afterBody(TableModel model) {
        boolean hasCalc = false;
        if (new Integer(model.getLimit().getTotalRows()) > 0) {
            hasCalc = this.calcBuilder.defaultCalcLayout();
        }
        this.html.append(this.calcBuilder.getHtmlBuilder());
        String extendRowAfter = (String)model.getTable().getAttribute("ExtendRowAfter");
        if (StringUtils.isNotBlank((String)extendRowAfter)) {
            this.html.append(extendRowAfter);
        }
        if (hasCalc) {
            this.html.tfootEnd(1);
        } else {
            this.tableBuilder.tbodyEnd();
        }
        this.tableBuilder.tableEnd();
        this.formBuilder.formEnd();
        this.tableBuilder.buildScript();
        if (this.bufferView) {
            return this.html.toString();
        }
        return "";
    }

    public void body(TableModel model, Column column) {
        if (column.isFirstColumn()) {
            this.rowBuilder.rowStart();
            this.html.newline();
        }
        this.html.append(column.getCellDisplay());
        this.html.newline();
        if (column.isLastColumn()) {
            this.rowBuilder.rowEnd();
        }
    }
}

