/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.view;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jxl.Cell;
import jxl.Workbook;
import jxl.biff.DisplayFormat;
import jxl.biff.FontRecord;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.write.Blank;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecside.common.log.LogHandler;
import org.ecside.core.ECSideContext;
import org.ecside.core.TableModel;
import org.ecside.core.bean.Column;
import org.ecside.table.calc.CalcResult;
import org.ecside.table.calc.CalcUtils;
import org.ecside.util.ECSideUtils;
import org.ecside.util.ExportViewUtils;
import org.ecside.util.ExtremeUtils;
import org.ecside.view.View;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.nodes.TagNode;
import org.htmlparser.tags.TableColumn;
import org.htmlparser.tags.TableRow;
import org.htmlparser.tags.TableTag;
import org.htmlparser.util.NodeList;

public class XlsView
implements View {
    private Log logger;
    public static final int WIDTH_MULT = 240;
    public static final int MIN_CHARS = 8;
    public static final short DEFAULT_FONT_HEIGHT = 8;
    public static final double NON_NUMERIC = -0.99999;
    public static final String DEFAULT_MONEY_FORMAT = "$###,###,##0.00";
    public static final String DEFAULT_PERCENT_FORMAT = "##0.0%";
    public static final String NBSP = "&nbsp;";
    public static final int colWidth = 15;
    private WritableWorkbook wb;
    private WritableSheet sheet;
    private int rownum;
    private short cellnum;
    private String moneyFormat;
    private String percentFormat;
    private ByteArrayOutputStream outputStream;
    private ByteArrayOutputStream outputStreamOut;
    private PrintWriter out;
    private String encoding;
    static /* synthetic */ Class class$0;

    public XlsView() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.ecside.view.XlsView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = LogFactory.getLog((Class)clazz);
        this.out = null;
        this.encoding = ECSideContext.ENCODING;
    }

    public void beforeBody(TableModel model) {
        this.logger.debug((Object)"XlsView.init()");
        this.outputStreamOut = this.outputStream = new ByteArrayOutputStream();
        this.out = new PrintWriter(this.outputStream);
        this.moneyFormat = model.getPreferences().getPreference("table.exportableformat.money");
        if (StringUtils.isEmpty((String)this.moneyFormat)) {
            this.moneyFormat = DEFAULT_MONEY_FORMAT;
        }
        this.percentFormat = model.getPreferences().getPreference("table.exportableformat.percent");
        if (StringUtils.isEmpty((String)this.percentFormat)) {
            this.percentFormat = DEFAULT_PERCENT_FORMAT;
        }
        try {
            this.wb = Workbook.createWorkbook((OutputStream)this.outputStream);
            this.sheet = this.wb.createSheet("Export Workbook", 0);
            this.createHeader(model);
            ++this.rownum;
            String extendRowBefore = (String)model.getTable().getAttribute("ExtendRowBefore");
            this.rownum += XlsView.createRow(this.sheet, XlsView.getRows(extendRowBefore, this.encoding), (CellFormat)WritableWorkbook.NORMAL_STYLE, this.rownum, 0) - 1;
        }
        catch (Exception e) {
            LogHandler.errorLog(this.logger, e);
        }
    }

    public static TableRow[] getRows(String inputHtml, String encode) throws Exception {
        if (StringUtils.isBlank((String)inputHtml)) {
            return null;
        }
        if (!(inputHtml = inputHtml.trim()).startsWith("<table>") && !inputHtml.startsWith("<TABLE>")) {
            inputHtml = "<table>" + inputHtml + "</table>";
        }
        Parser parser = Parser.createParser((String)inputHtml, (String)encode);
        NodeList nodes = parser.extractAllNodesThatMatch((NodeFilter)new /* Unavailable Anonymous Inner Class!! */);
        TagNode node = (TagNode)nodes.elementAt(0);
        return ((TableTag)node).getRows();
    }

    public static int getColumnNum(TableRow row) {
        int totalCol = 0;
        TableColumn[] columns = row.getColumns();
        int cn = 0;
        while (cn < columns.length) {
            block4: {
                String colspan = columns[cn].getAttribute("colspan");
                if (colspan != null && colspan.length() > 0) {
                    try {
                        totalCol += Integer.parseInt(colspan);
                        break block4;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++totalCol;
            }
            ++cn;
        }
        return totalCol;
    }

    public static int createRow(WritableSheet sheet, TableRow[] tableRows, CellFormat cellFormat, int startRow, int startCol) throws RowsExceededException, WriteException {
        if (tableRows == null || tableRows.length < 1) {
            return 0;
        }
        int totalCol = XlsView.getColumnNum(tableRows[0]);
        int colWidth = 15;
        ArrayList<int[]> mergeCells = new ArrayList<int[]>();
        int rowNo = startRow;
        while (rowNo < startRow + tableRows.length) {
            int idx = 0;
            int colNo = startCol;
            while (colNo < startCol + totalCol) {
                Cell cell = sheet.getCell(colNo, rowNo);
                if (!(cell instanceof Blank)) {
                    TableColumn tdBean = tableRows[rowNo - startRow].getColumns()[idx];
                    String title = ECSideUtils.specialHTMLToShowTEXT(tdBean.toPlainTextString());
                    Label label = new Label(colNo, rowNo, title, cellFormat);
                    sheet.addCell((WritableCell)label);
                    sheet.setColumnView(colNo, colWidth);
                    ++idx;
                    int ce = Integer.parseInt(ECSideUtils.convertString(tdBean.getAttribute("colspan"), "1")) - 1;
                    int re = Integer.parseInt(ECSideUtils.convertString(tdBean.getAttribute("rowspan"), "1")) - 1;
                    if (ce >= 1 || re >= 1) {
                        int scolNo;
                        ce = ce < 0 ? 0 : ce;
                        re = re < 0 ? 0 : re;
                        mergeCells.add(new int[]{colNo, rowNo, colNo + ce, rowNo + re});
                        if (ce < 1 && re >= 1) {
                            int srowNo = 1;
                            while (srowNo <= re) {
                                sheet.addCell((WritableCell)new Blank(colNo, rowNo + srowNo));
                                sheet.setColumnView(colNo, colWidth);
                                ++srowNo;
                            }
                        } else if (re < 1 && ce >= 1) {
                            scolNo = 1;
                            while (scolNo <= ce) {
                                sheet.addCell((WritableCell)new Blank(colNo + scolNo, rowNo));
                                sheet.setColumnView(colNo + scolNo, colWidth);
                                ++scolNo;
                            }
                            colNo += ce;
                        } else if (ce >= 1 && re >= 1) {
                            scolNo = 1;
                            while (scolNo <= ce) {
                                int srowNo = 1;
                                while (srowNo <= re) {
                                    sheet.addCell((WritableCell)new Blank(colNo + scolNo, rowNo + srowNo));
                                    sheet.setColumnView(colNo + scolNo, colWidth);
                                    ++srowNo;
                                }
                                ++scolNo;
                            }
                            colNo += ce;
                        }
                    }
                }
                ++colNo;
            }
            ++rowNo;
        }
        int i = 0;
        while (i < mergeCells.size()) {
            int[] mc = (int[])mergeCells.get(i);
            sheet.mergeCells(mc[0], mc[1], mc[2], mc[3]);
            ++i;
        }
        return tableRows.length;
    }

    private void createHeader(TableModel model) throws RowsExceededException, WriteException {
        this.rownum = 0;
        this.cellnum = 0;
        int etr = 0;
        WritableCellFormat cellFormat = new WritableCellFormat();
        WritableFont arial10font = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
        cellFormat.setBackground(Colour.GRAY_25);
        cellFormat.setBorder(Border.ALL, BorderLineStyle.THIN, Colour.GRAY_50);
        cellFormat.setFont((FontRecord)arial10font);
        boolean showHeader = model.getTable().isShowHeader();
        List columns = model.getColumnHandler().getHeaderColumns();
        String extendRowTop = (String)model.getTable().getAttribute("ExtendRowTop");
        try {
            etr = XlsView.createRow(this.sheet, XlsView.getRows(extendRowTop, this.encoding), (CellFormat)cellFormat, this.rownum, 0);
        }
        catch (Exception e) {
            LogHandler.warnLog(this.logger, e);
            etr = 0;
        }
        this.rownum += etr;
        if (showHeader || etr < 1) {
            Iterator iter = columns.iterator();
            while (iter.hasNext()) {
                Column column = (Column)iter.next();
                String title = column.getCellDisplay();
                Label label = new Label((int)this.cellnum, this.rownum, title, (CellFormat)cellFormat);
                this.sheet.addCell((WritableCell)label);
                int valWidth = String.valueOf(title).length();
                valWidth = 1;
                this.sheet.setColumnView((int)this.cellnum, valWidth * 15);
                this.cellnum = (short)(this.cellnum + 1);
            }
        } else if (this.rownum > 0) {
            --this.rownum;
        }
    }

    public void body(TableModel model, Column column) {
        if (column.isFirstColumn()) {
            ++this.rownum;
            this.cellnum = 0;
        }
        try {
            String value = ExportViewUtils.parseXLS(column.getCellDisplay());
            if (column.isEscapeAutoFormat()) {
                this.writeToCellAsText(value, null);
            } else {
                this.writeToCellFormatted(value, null);
            }
            this.cellnum = (short)(this.cellnum + 1);
        }
        catch (RowsExceededException e) {
            LogHandler.errorLog(this.logger, e);
        }
        catch (WriteException e) {
            LogHandler.errorLog(this.logger, e);
        }
    }

    public Object afterBody(TableModel model) {
        if (model.getLimit().getTotalRows() != 0) {
            try {
                this.totals(model);
            }
            catch (RowsExceededException e) {
                LogHandler.errorLog(this.logger, e);
            }
            catch (WriteException e) {
                LogHandler.errorLog(this.logger, e);
            }
        }
        try {
            ++this.rownum;
            String extendRowAfter = (String)model.getTable().getAttribute("ExtendRowAfter");
            this.rownum += XlsView.createRow(this.sheet, XlsView.getRows(extendRowAfter, this.encoding), (CellFormat)WritableWorkbook.NORMAL_STYLE, this.rownum, 0);
            this.wb.write();
            this.wb.close();
            this.out.flush();
            this.out.close();
        }
        catch (WriteException e) {
            LogHandler.warnLog(this.logger, e);
        }
        catch (IOException e) {
            LogHandler.warnLog(this.logger, e);
        }
        catch (Exception e) {
            LogHandler.warnLog(this.logger, e);
        }
        return this.outputStreamOut;
    }

    private void writeToCellAsText(String value, WritableCellFormat styleModifier) throws RowsExceededException, WriteException {
        if (value.trim().equals(NBSP)) {
            value = "";
        }
        Label label = new Label((int)this.cellnum, this.rownum, value);
        if (styleModifier != null) {
            label.setCellFormat((CellFormat)styleModifier);
        }
        this.sheet.addCell((WritableCell)label);
    }

    private void writeToCellFormatted(String value, WritableCellFormat styleModifier) throws RowsExceededException, WriteException {
        double numeric = -0.99999;
        try {
            numeric = Double.parseDouble(value);
        }
        catch (Exception e) {
            numeric = -0.99999;
        }
        if (value.startsWith("$") || value.endsWith("%") || value.startsWith("($")) {
            boolean moneyFlag = value.startsWith("$") || value.startsWith("($");
            boolean percentFlag = value.endsWith("%");
            value = StringUtils.replace((String)value, (String)"$", (String)"");
            value = StringUtils.replace((String)value, (String)"%", (String)"");
            value = StringUtils.replace((String)value, (String)",", (String)"");
            value = StringUtils.replace((String)value, (String)"(", (String)"-");
            value = StringUtils.replace((String)value, (String)")", (String)"");
            try {
                numeric = Double.parseDouble(value);
            }
            catch (Exception e) {
                numeric = -0.99999;
            }
            if (moneyFlag) {
                NumberFormat fivedps = new NumberFormat(this.moneyFormat);
                WritableCellFormat fivedpsFormat = new WritableCellFormat((DisplayFormat)fivedps);
                Number number = new Number((int)this.cellnum, this.rownum, numeric, (CellFormat)fivedpsFormat);
                if (styleModifier != null) {
                    number.setCellFormat((CellFormat)styleModifier);
                }
                this.sheet.addCell((WritableCell)number);
            } else if (percentFlag) {
                NumberFormat fivedps = new NumberFormat(this.percentFormat);
                WritableCellFormat fivedpsFormat = new WritableCellFormat((DisplayFormat)fivedps);
                Number number = new Number((int)this.cellnum, this.rownum, numeric /= 100.0, (CellFormat)fivedpsFormat);
                if (styleModifier != null) {
                    number.setCellFormat((CellFormat)styleModifier);
                }
                this.sheet.addCell((WritableCell)number);
            }
        } else if (Math.abs(numeric - -0.99999) >= 1.0E-7) {
            Number number = new Number((int)this.cellnum, this.rownum, numeric);
            if (styleModifier != null) {
                number.setCellFormat((CellFormat)styleModifier);
            }
            this.sheet.addCell((WritableCell)number);
        } else {
            if (value.trim().equals(NBSP)) {
                value = "";
            }
            Label label = new Label((int)this.cellnum, this.rownum, value);
            if (styleModifier != null) {
                label.setCellFormat((CellFormat)styleModifier);
            }
            this.sheet.addCell((WritableCell)label);
        }
    }

    public void totals(TableModel model) throws RowsExceededException, WriteException {
        Column firstCalcColumn = model.getColumnHandler().getFirstCalcColumn();
        WritableCellFormat cellFormatTotals = new WritableCellFormat();
        cellFormatTotals.setBackground(Colour.GRAY_25);
        cellFormatTotals.setBorder(Border.ALL, BorderLineStyle.THIN, Colour.GRAY_50);
        if (firstCalcColumn != null) {
            int rows = firstCalcColumn.getCalc().length;
            int i = 0;
            while (i < rows) {
                ++this.rownum;
                this.cellnum = 0;
                Iterator iter = model.getColumnHandler().getColumns().iterator();
                while (iter.hasNext()) {
                    Column column = (Column)iter.next();
                    if (column.isFirstColumn()) {
                        String calcTitle = CalcUtils.getFirstCalcColumnTitleByPosition(model, i);
                        if (column.isEscapeAutoFormat()) {
                            this.writeToCellAsText(calcTitle, cellFormatTotals);
                        } else {
                            this.writeToCellFormatted(calcTitle, cellFormatTotals);
                        }
                        this.cellnum = (short)(this.cellnum + 1);
                        continue;
                    }
                    if (column.isCalculated()) {
                        CalcResult calcResult = CalcUtils.getCalcResultsByPosition(model, column, i);
                        java.lang.Number value = calcResult.getValue();
                        if (value != null) {
                            if (StringUtils.isNotBlank((String)column.getFormat())) {
                                this.writeToCellFormatted(ExtremeUtils.formatNumber(column.getFormat(), value, model.getLocale()), cellFormatTotals);
                            } else {
                                this.writeToCellAsText(value.toString(), cellFormatTotals);
                            }
                        } else {
                            Label label = new Label((int)this.cellnum, this.rownum, "n/a");
                            this.sheet.addCell((WritableCell)label);
                        }
                        this.cellnum = (short)(this.cellnum + 1);
                        continue;
                    }
                    this.writeToCellFormatted("", cellFormatTotals);
                    this.cellnum = (short)(this.cellnum + 1);
                }
                ++i;
            }
        }
    }
}

