/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.view.html;

import org.apache.commons.lang.StringUtils;
import org.ecside.core.TableModel;

public class BuilderUtils {
    private BuilderUtils() {
    }

    public static boolean showPagination(TableModel model) {
        String showToolBar = model.getTable().getToolbarLocation();
        return showToolBar != null && showToolBar.length() > 0 && !showToolBar.equalsIgnoreCase("none") && !showToolBar.equalsIgnoreCase("null") && !showToolBar.equalsIgnoreCase("false");
    }

    public static boolean showExports(TableModel model) {
        return model.getExportHandler().getExports().size() > 0;
    }

    public static boolean showTitle(TableModel model) {
        return model.getTable().isShowTitle();
    }

    public static boolean filterable(TableModel model) {
        return model.getTable().isFilterable();
    }

    public static boolean isFirstPageEnabled(int page) {
        return page != 1;
    }

    public static boolean isPrevPageEnabled(int page) {
        return page - 1 >= 1;
    }

    public static boolean isNextPageEnabled(int page, int totalPages) {
        return page + 1 <= totalPages;
    }

    public static boolean isLastPageEnabled(int page, int totalPages) {
        return page != totalPages && totalPages != 0;
    }

    public static int getTotalPages(TableModel model) {
        int currentRowsDisplayed = model.getLimit().getCurrentRowsDisplayed();
        if (currentRowsDisplayed == 0) {
            currentRowsDisplayed = model.getLimit().getTotalRows();
        }
        int totalRows = model.getLimit().getTotalRows();
        int totalPages = 1;
        if (currentRowsDisplayed != 0) {
            totalPages = totalRows / currentRowsDisplayed;
        }
        if (currentRowsDisplayed != 0 && totalRows % currentRowsDisplayed > 0) {
            ++totalPages;
        }
        return totalPages;
    }

    public static String getImage(TableModel model, String imageName) {
        String imagePath = model.getTable().getImagePath();
        if (StringUtils.isNotBlank((String)imagePath)) {
            int index = imagePath.indexOf("*.");
            return String.valueOf(imagePath.substring(0, index)) + imageName + imagePath.substring(index + 1);
        }
        return null;
    }

    public static String getForm(TableModel model) {
        String form = model.getTable().getForm();
        if (StringUtils.isBlank((String)form)) {
            form = model.getTable().getTableId();
        }
        return form;
    }
}

