/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.view.html;

import java.util.Iterator;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecside.core.TableModel;
import org.ecside.core.bean.Column;
import org.ecside.core.bean.Table;
import org.ecside.table.calc.CalcResult;
import org.ecside.table.calc.CalcUtils;
import org.ecside.util.ExtremeUtils;
import org.ecside.util.HtmlBuilder;
import org.ecside.view.html.TableBuilder;

public class CalcBuilder {
    private Log logger;
    private HtmlBuilder html;
    private TableModel model;
    private Table table;
    private boolean isClassic;
    static /* synthetic */ Class class$0;

    public CalcBuilder(TableModel model) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.ecside.view.html.CalcBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = LogFactory.getLog((Class)clazz);
        this.model = model;
        this.html = new HtmlBuilder();
        this.table = model.getTable();
        this.isClassic = this.table.isClassic();
    }

    public void singleRowCalcResults() {
        int spanNum = 0;
        int columnIndex = -1;
        this.html.tbodyEnd(1);
        this.html.tfoot(1).id(String.valueOf(this.model.getTableHandler().prefixWithTableId()) + "table" + "_foot").close();
        new TableBuilder(this.html, this.model).bodyHideRow();
        this.html.tr(1).styleClass("calcRow").close();
        Iterator iter = this.model.getColumnHandler().getColumns().iterator();
        while (iter.hasNext()) {
            int i;
            Column column = (Column)iter.next();
            ++columnIndex;
            if (column.isFirstColumn()) {
                spanNum = column.getCalcSpan();
                spanNum = spanNum < 1 ? 1 : spanNum;
                String[] calcTitle = CalcUtils.getFirstCalcColumnTitles(this.model);
                if (calcTitle == null || calcTitle.length <= 0) continue;
                this.html.td(2).styleClass("calcTitle");
                if (spanNum > 1) {
                    this.html.append(" colspan=\"" + spanNum + "\" ");
                }
                this.html.close();
                i = 0;
                while (i < calcTitle.length) {
                    String title = calcTitle[i];
                    this.html.append(title);
                    if (calcTitle.length > 0 && i + 1 != calcTitle.length) {
                        this.html.append(" / ");
                    }
                    ++i;
                }
                this.html.tdEnd();
                continue;
            }
            if (columnIndex < spanNum) continue;
            if (column.isCalculated()) {
                this.html.td(2).styleClass("calcResult").close();
                CalcResult[] calcResults = CalcUtils.getCalcResults(this.model, column);
                i = 0;
                while (i < calcResults.length) {
                    CalcResult calcResult = calcResults[i];
                    Number value = calcResult.getValue();
                    if (value == null) {
                        this.html.append(calcResult.getName());
                    } else {
                        this.html.append(ExtremeUtils.formatNumber(column.getFormat(), value, this.model.getLocale()));
                    }
                    if (calcResults.length > 0 && i + 1 != calcResults.length) {
                        this.html.append(" / ");
                    }
                    ++i;
                }
            } else {
                this.html.td(2).close();
                this.html.nbsp();
            }
            this.html.tdEnd();
        }
        this.html.trEnd(1);
    }

    public void multiRowCalcResults() {
        Column firstCalcColumn = this.model.getColumnHandler().getFirstCalcColumn();
        int rows = firstCalcColumn.getCalc().length;
        this.html.tbodyEnd(1);
        this.html.tfoot(1).id(String.valueOf(this.model.getTableHandler().prefixWithTableId()) + "table" + "_foot").close();
        if (!this.isClassic) {
            new TableBuilder(this.html, this.model).bodyHideRow();
        }
        int i = 0;
        while (i < rows) {
            this.html.tr(1).styleClass("calcRow").close();
            int spanNum = 0;
            int columnIndex = -1;
            Iterator iter = this.model.getColumnHandler().getColumns().iterator();
            while (iter.hasNext()) {
                Column column = (Column)iter.next();
                ++columnIndex;
                if (column.isFirstColumn()) {
                    spanNum = column.getCalcSpan();
                    spanNum = spanNum < 1 ? 1 : spanNum;
                    String calcTitle = CalcUtils.getFirstCalcColumnTitleByPosition(this.model, i);
                    this.html.td(2).styleClass("calcTitle");
                    if (spanNum > 1) {
                        this.html.append(" colspan=\"" + spanNum + "\" ");
                    }
                    this.html.close();
                    this.html.append(calcTitle);
                    this.html.tdEnd();
                    continue;
                }
                if (columnIndex < spanNum) continue;
                if (column.isCalculated()) {
                    this.html.td(2).styleClass("calcResult").close();
                    CalcResult calcResult = CalcUtils.getCalcResultsByPosition(this.model, column, i);
                    Number value = calcResult.getValue();
                    if (value == null) {
                        this.html.append(calcResult.getName());
                    } else {
                        this.html.append(ExtremeUtils.formatNumber(column.getFormat(), value, this.model.getLocale()));
                    }
                } else {
                    this.html.td(2).close();
                    this.html.nbsp();
                }
                this.html.tdEnd();
            }
            this.html.trEnd(1);
            ++i;
        }
    }

    public boolean defaultCalcLayout() {
        boolean hasCalc = false;
        Column calcColumn = this.model.getColumnHandler().getFirstCalcColumn();
        if (calcColumn == null) {
            return hasCalc;
        }
        String layout = this.model.getPreferences().getPreference("defaultCalcLayout");
        try {
            MethodUtils.invokeExactMethod((Object)this, (String)layout, null);
            hasCalc = true;
        }
        catch (Exception e) {
            this.logger.error((Object)("There is no method with the layout [" + layout + "]."), (Throwable)e);
        }
        return hasCalc;
    }

    public HtmlBuilder getHtmlBuilder() {
        return this.html;
    }

    protected TableModel getTableModel() {
        return this.model;
    }

    public String toString() {
        return this.html.toString();
    }
}

