/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.view.html;

import org.apache.commons.lang.StringUtils;
import org.ecside.core.bean.Column;
import org.ecside.util.ECSideUtils;
import org.ecside.util.HtmlBuilder;

public class ColumnBuilder {
    private HtmlBuilder html;
    private Column column;

    public ColumnBuilder(Column column) {
        this(new HtmlBuilder(), column);
    }

    public ColumnBuilder(HtmlBuilder html, Column column) {
        this.html = html;
        this.column = column;
    }

    public void cellEdit() {
        String cellValue = this.column.getPropertyValueAsString();
        if (StringUtils.isNotBlank((String)cellValue)) {
            this.html.append(" cellValue=\"").append(cellValue.replaceAll("\"", "\\\"")).append("\" ");
        }
        this.html.attribute(this.column.getEditEvent(), "ECSideUtil.editCell(this,'" + this.column.getModel().getTable().getTableId() + "')");
    }

    public void tdStart() {
        this.html.td(2);
        if (StringUtils.isNotBlank((String)this.column.getId())) {
            this.html.append(" id=\"" + this.column.getId() + "\" ");
        }
        this.styleClass();
        this.style();
        this.width();
        this.onclick();
        this.ondblclick();
        this.onmouseover();
        this.onmouseout();
        if (StringUtils.isNotBlank((String)this.column.getNowrap())) {
            this.html.append(" nowrap=\"" + this.column.getNowrap() + "\" ");
        }
        if (StringUtils.isNotBlank((String)this.column.getTipTitle())) {
            this.html.append(" title=\"" + this.column.getTipTitle() + "\" ");
        }
        if (this.column.isEditable()) {
            this.cellEdit();
        } else {
            String cellValue = this.column.getCellValue();
            if (StringUtils.isNotBlank((String)cellValue)) {
                this.html.append(" cellValue=\"").append(cellValue.replaceAll("\"", "\\\"")).append("\" ");
            }
        }
        this.html.append(" ").append(ECSideUtils.nullToBlank(this.column.getTagAttributes())).append(" ");
        String extendAttribute = (String)this.column.getAttribute("attributes");
        if (extendAttribute != null) {
            this.html.append(extendAttribute.replaceAll("\r\n", " "));
        }
        this.html.close();
    }

    public void onclick() {
        String onclick = this.column.getOnclick();
        if (onclick == null || onclick.length() < 1) {
            return;
        }
        this.html.append(" onclick=\"" + onclick + "\" ");
    }

    public void ondblclick() {
        String ondblclick = this.column.getOndblclick();
        if (ondblclick == null || ondblclick.length() < 1) {
            return;
        }
        this.html.append(" ondblclick=\"" + ondblclick + "\" ");
    }

    public void onmouseover() {
        String onmouseover = this.column.getOnmouseover();
        if (StringUtils.isBlank((String)onmouseover)) {
            return;
        }
        this.html.append(" onmouseover=\"" + onmouseover + "\" ");
    }

    public void onmouseout() {
        String onmouseout = this.column.getOnmouseout();
        if (StringUtils.isBlank((String)onmouseout)) {
            return;
        }
        this.html.append(" onmouseout=\"" + onmouseout + "\" ");
    }

    public HtmlBuilder getHtmlBuilder() {
        return this.html;
    }

    protected Column getColumn() {
        return this.column;
    }

    public void tdEnd() {
        this.html.tdEnd();
    }

    public void style() {
        String style = this.column.getStyle();
        this.html.style(style);
    }

    public void styleClass() {
        String styleClass = this.column.getStyleClass();
        this.html.styleClass(styleClass);
    }

    public void width() {
        String width = this.column.getWidth();
        this.html.width(width);
    }

    public void tdBody(String value) {
        if (StringUtils.isNotBlank((String)value)) {
            this.html.append(value);
        } else {
            this.html.nbsp();
        }
    }

    public String toString() {
        return this.html.toString();
    }
}

