/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.view.html;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.ecside.core.TableModel;
import org.ecside.core.bean.Column;
import org.ecside.core.bean.Table;
import org.ecside.table.limit.Sort;
import org.ecside.util.ECSideUtils;
import org.ecside.util.HtmlBuilder;
import org.ecside.view.html.BuilderUtils;

public class FormBuilder {
    private HtmlBuilder html;
    private TableModel model;
    private Table table;
    private boolean isClassic;

    public FormBuilder(TableModel model) {
        this(new HtmlBuilder(), model);
    }

    public FormBuilder(HtmlBuilder html, TableModel model) {
        this.html = html;
        this.model = model;
        this.table = model.getTable();
        this.isClassic = this.table.isClassic();
    }

    public HtmlBuilder getHtmlBuilder() {
        return this.html;
    }

    protected TableModel getTableModel() {
        return this.model;
    }

    public void formStart() {
        this.formAttributes();
        this.html.newline();
        this.html.div().close();
        this.instanceParameter();
        this.exportTableIdParameter();
        this.exportParameters();
        this.rowsDisplayedParameter();
        this.filterParameter();
        this.pageParameters();
        this.sortParameters();
        this.aliasParameters();
        this.userDefinedParameters();
        this.hiddenTotalField();
        this.filterField();
        this.html.newline();
        this.html.divEnd();
    }

    public void hiddenTotalField() {
        int currentRowsDisplayed = this.getTableModel().getLimit().getCurrentRowsDisplayed();
        int totalPages = 0;
        int totalRows = this.getTableModel().getLimit().getTotalRows();
        totalPages = currentRowsDisplayed > 0 ? (int)Math.ceil((double)totalRows / (double)currentRowsDisplayed) : 1;
        this.html.newline();
        this.html.input("hidden").name(String.valueOf(this.model.getTableHandler().prefixWithTableId()) + "totalpages").value("" + totalPages).xclose();
        this.html.newline();
        this.html.input("hidden").name(String.valueOf(this.model.getTableHandler().prefixWithTableId()) + "totalrows").value("" + totalRows).xclose();
    }

    public void formEnd() {
        String shadowRow = (String)this.table.getAttribute("shadowRow");
        if (StringUtils.isNotBlank((String)shadowRow)) {
            this.html.div();
            this.html.id(String.valueOf(this.model.getTableHandler().prefixWithTableId()) + "shadowRow");
            this.html.style("display:none;");
            this.html.close();
            this.html.append(shadowRow);
            this.html.divEnd();
        }
        this.html.newline().append(ECSideUtils.getAjaxEnd(this.table.getTableId()));
        this.html.newline().divEnd();
        this.extendTableBottom();
        String form = this.table.getForm();
        if (StringUtils.isBlank((String)form)) {
            this.html.formEnd();
        }
    }

    public void formAttributes() {
        String form = this.table.getForm();
        String tableId = this.table.getTableId();
        String width = this.table.getWidth();
        if (width != null && width.indexOf("px") == -1 && width.indexOf("%") == -1) {
            width = String.valueOf(width) + "px";
        }
        if (StringUtils.isBlank((String)form)) {
            String maxRowsExportedS;
            int maxRowsExported;
            boolean canResizeColWidth;
            this.html.form();
            this.html.id(tableId);
            this.html.method(this.table.getMethod());
            this.html.style("width:" + width + ";visibility :hidden;");
            String nearPageNumS = this.getTableModel().getTable().getNearPageNum();
            int nearPageNum = new Integer(nearPageNumS);
            if (nearPageNum > 0) {
                this.html.append(" nearPages=\"" + nearPageNum + "\" ");
            }
            if (this.table.isFilterable()) {
                this.html.append(" filterable=\"true\" ");
            }
            if (canResizeColWidth = this.table.isResizeColWidth()) {
                this.html.append(" canResizeColWidth=\"").append(String.valueOf(canResizeColWidth)).append("\" ");
            }
            if ((maxRowsExported = new Integer(maxRowsExportedS = this.getTableModel().getTable().getMaxRowsExported()).intValue()) > 0) {
                this.html.append(" maxRowsExported=\"").append(String.valueOf(maxRowsExported)).append("\" ");
            }
            int minColWidth = this.table.getMinColWidth();
            this.html.append(" minColWidth=\"").append(String.valueOf(minColWidth)).append("\" ");
            this.html.newline();
            this.html.action(this.table.getAction());
            this.html.enctype(this.table.getEnctype());
            this.html.attribute("insertAction", this.table.getInsertAction());
            this.html.attribute("updateAction", this.table.getUpdateAction());
            this.html.attribute("deleteAction", this.table.getDeleteAction());
            this.html.attribute("shadowRowAction", this.table.getShadowRowAction());
            this.html.close();
        }
        String theme = this.table.getTheme();
        this.html.newline().div().styleClass(theme).id(String.valueOf(this.model.getTableHandler().prefixWithTableId()) + "main_content");
        this.html.style("width:" + width + ";").close();
        this.html.newline().append(ECSideUtils.getAjaxBegin(tableId));
        this.extendTableTop();
    }

    public void instanceParameter() {
        this.html.newline();
        this.html.input("hidden");
        this.html.name("ec_i");
        this.html.value(this.table.getTableId());
        this.html.xclose();
    }

    public void filterParameter() {
        if (BuilderUtils.filterable(this.model)) {
            this.html.newline();
            this.html.input("hidden");
            this.html.name(String.valueOf(this.model.getTableHandler().prefixWithTableId()) + "f_" + "a");
            if (this.model.getLimit().isFiltered()) {
                this.html.value("fa");
            }
            this.html.xclose();
        }
    }

    public void filterField() {
        if (!this.table.isFilterable()) {
            return;
        }
        List columns = this.model.getColumnHandler().getFilterColumns();
        if (columns.size() > 0) {
            this.html.newline();
            Iterator iter = columns.iterator();
            while (iter.hasNext()) {
                this.html.append(FormBuilder.filterHiddenInput(this.model, (Column)iter.next()));
            }
            this.html.newline();
        }
    }

    public static String filterHiddenInput(TableModel model, Column column) {
        HtmlBuilder html = new HtmlBuilder();
        if (column.isFilterable()) {
            html.input("hidden");
            html.name(String.valueOf(model.getTableHandler().prefixWithTableId()) + "f_" + column.getAlias());
            String value = column.getValueAsString();
            if (StringUtils.isNotBlank((String)value)) {
                html.value(value);
            }
            html.xclose();
        }
        return html.toString();
    }

    public void rowsDisplayedParameter() {
        this.html.newline();
        this.html.input("hidden");
        this.html.name(String.valueOf(this.model.getTableHandler().prefixWithTableId()) + "crd");
        int currentRowsDisplayed = this.model.getLimit().getCurrentRowsDisplayed();
        this.html.value(String.valueOf(currentRowsDisplayed));
        this.html.xclose();
    }

    public void pageParameters() {
        this.html.newline();
        this.html.input("hidden");
        this.html.name(String.valueOf(this.model.getTableHandler().prefixWithTableId()) + "p");
        int page = this.model.getLimit().getPage();
        if (page > 0) {
            this.html.value(String.valueOf(page));
        }
        this.html.xclose();
    }

    public void exportTableIdParameter() {
        String existingForm2;
        String existingForm;
        if (!BuilderUtils.showExports(this.model)) {
            return;
        }
        String form = BuilderUtils.getForm(this.model);
        if (!form.equals(existingForm = (String)this.model.getContext().getRequestAttribute("eti"))) {
            this.html.newline();
            this.html.input("hidden");
            this.html.name("eti");
            this.html.xclose();
            this.model.getContext().setRequestAttribute("eti", form);
        }
        if (!form.equals(existingForm2 = (String)this.model.getContext().getRequestAttribute("eti_p"))) {
            this.html.newline();
            this.html.input("hidden");
            this.html.name("eti_p");
            this.html.xclose();
            this.model.getContext().setRequestAttribute("eti_p", form);
        }
    }

    public void exportParameters() {
        this.html.newline();
        this.html.input("hidden");
        this.html.name(String.valueOf(this.model.getTableHandler().prefixWithTableId()) + "efn");
        this.html.xclose();
        if (!BuilderUtils.showExports(this.model)) {
            return;
        }
        this.html.newline();
        this.html.input("hidden");
        this.html.name(String.valueOf(this.model.getTableHandler().prefixWithTableId()) + "ev");
        this.html.xclose();
    }

    public void sortParameters() {
        List columns = this.model.getColumnHandler().getColumns();
        Iterator iter = columns.iterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            if (!column.isSortable()) continue;
            this.html.newline();
            this.html.input("hidden");
            this.html.name(String.valueOf(this.model.getTableHandler().prefixWithTableId()) + "s_" + column.getAlias());
            Sort sort = this.model.getLimit().getSort();
            if (sort.isSorted() && sort.getAlias().equals(column.getAlias())) {
                this.html.value(sort.getSortOrder());
            }
            this.html.xclose();
        }
    }

    public boolean isInParameters(String parametersNames, String name) {
        String[] t = parametersNames.split(",");
        int i = 0;
        while (i < t.length) {
            if (ECSideUtils.isSearchMatch(name, t[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void userDefinedParameters() {
        Map parameterMap = this.model.getRegistry().getParameterMap();
        String includeParameters = this.table.getIncludeParameters();
        String excludeParameters = this.table.getExcludeParameters();
        Set keys = parameterMap.keySet();
        Object[] keyField = new String[]{"easyDataAccess", "easyList", "easyDataExport"};
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (name.startsWith(this.model.getTableHandler().prefixWithTableId()) || excludeParameters != null && this.isInParameters(excludeParameters, name) || includeParameters != null && !this.isInParameters(includeParameters, name) || ArrayUtils.contains((Object[])keyField, (Object)name)) continue;
            String[] values = (String[])parameterMap.get(name);
            if (values == null || values.length == 0) {
                this.html.newline();
                this.html.input("hidden").name(name).xclose();
                continue;
            }
            int i = 0;
            while (i < values.length) {
                this.html.newline();
                this.html.input("hidden").name(name).value(values[i]).xclose();
                ++i;
            }
        }
    }

    public void aliasParameters() {
        List columns = this.model.getColumnHandler().getColumns();
        Iterator iter = columns.iterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            if (!StringUtils.isNotBlank((String)column.getProperty()) || column.getProperty().equals(column.getAlias())) continue;
            this.html.newline();
            this.html.input("hidden");
            this.html.name(String.valueOf(this.model.getTableHandler().prefixWithTableId()) + "a_" + column.getAlias());
            this.html.value(column.getProperty());
            this.html.xclose();
        }
    }

    public void extendTableTop() {
        String extendTableTop = (String)this.table.getAttribute("ExtendTableTop");
        if (StringUtils.isNotBlank((String)extendTableTop)) {
            this.html.newline();
            this.html.append(extendTableTop);
        }
    }

    public void extendTableBottom() {
        String extendTableBottom = (String)this.table.getAttribute("ExtendTableBottom");
        if (StringUtils.isNotBlank((String)extendTableBottom)) {
            this.html.newline();
            this.html.append(extendTableBottom);
        }
    }

    public String toString() {
        return this.html.toString();
    }
}

