/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.view.html;

import org.apache.commons.lang.StringUtils;
import org.ecside.core.TableModel;
import org.ecside.core.bean.Row;
import org.ecside.core.bean.Table;
import org.ecside.util.ECSideUtils;
import org.ecside.util.HtmlBuilder;

public class RowBuilder {
    private HtmlBuilder html;
    private TableModel model;
    private Row row;

    public RowBuilder(TableModel model) {
        this(new HtmlBuilder(), model);
    }

    public RowBuilder(HtmlBuilder html, TableModel model) {
        this.html = html;
        this.model = model;
        this.row = model.getRowHandler().getRow();
    }

    public void rowStart() {
        this.html.tr(0);
        if (StringUtils.isNotBlank((String)this.row.getId())) {
            this.html.append(" id=\"" + this.row.getId() + "\" ");
        }
        this.styleClass();
        this.style();
        this.onclick();
        this.ondblclick();
        this.onmouseover();
        this.onmouseout();
        this.html.append(" ").append(ECSideUtils.nullToBlank(this.row.getTagAttributes())).append(" ");
        this.html.append(this.row.getAttribute("attributes"));
        String recordKey = this.row.getRecordKey();
        if (StringUtils.isNotBlank((String)recordKey)) {
            this.html.append(" recordKey=\"").append(recordKey).append("\" ");
        }
        this.html.close();
    }

    public void ondblclick() {
        String ondblclick = this.row.getOndblclick();
        if (ondblclick == null || ondblclick.length() < 1) {
            return;
        }
        this.html.append(" ondblclick=\"" + ondblclick + "\" ");
    }

    public HtmlBuilder getHtmlBuilder() {
        return this.html;
    }

    public void setHtmlBuilder(HtmlBuilder html) {
        this.html = html;
    }

    protected TableModel getTableModel() {
        return this.model;
    }

    protected Row getRow() {
        return this.row;
    }

    public void rowEnd() {
        this.html.trEnd(1);
    }

    public void style() {
        String style = this.row.getStyle();
        this.html.style(style);
    }

    public void styleClass() {
        String styleClass = ECSideUtils.convertString(this.getStyleClass(), "");
        Table table = this.model.getTable();
        String oddBgcolor = table.getOddRowBgColor();
        String evenBgcolor = table.getEvenRowBgColor();
        if (this.model.getRowHandler().isRowEven()) {
            if (StringUtils.isNotBlank((String)evenBgcolor)) {
                this.html.append(" bgcolor=\"" + evenBgcolor + "\" ");
            } else {
                styleClass = String.valueOf(styleClass) + "even ";
            }
        } else if (StringUtils.isNotBlank((String)oddBgcolor)) {
            this.html.append(" bgcolor=\"" + oddBgcolor + "\" ");
        } else {
            styleClass = String.valueOf(styleClass) + "odd ";
        }
        this.html.styleClass(styleClass);
    }

    public void onclick() {
        String onclick = "";
        if (this.row.getSelectlightRow().booleanValue()) {
            onclick = String.valueOf(onclick) + "ECSideUtil.selectRow(this,'" + this.model.getTable().getTableId() + "');";
        }
        if (StringUtils.isNotBlank((String)this.row.getOnclick())) {
            onclick = String.valueOf(onclick) + this.row.getOnclick();
        }
        this.html.onclick(onclick);
    }

    public void onmouseover() {
        boolean highlightRow = this.row.isHighlightRow();
        if (highlightRow) {
            this.html.onmouseover("ECSideUtil.lightRow(this,'" + this.model.getTable().getTableId() + "');" + ECSideUtils.convertString(this.row.getOnmouseover(), ""));
        } else {
            this.html.onmouseover(this.row.getOnmouseover());
        }
    }

    public void onmouseout() {
        boolean highlightRow = this.row.isHighlightRow();
        if (highlightRow) {
            this.html.onmouseout("ECSideUtil.unlightRow(this,'" + this.model.getTable().getTableId() + "');" + ECSideUtils.convertString(this.row.getOnmouseout(), ""));
        } else {
            this.html.onmouseout(this.row.getOnmouseout());
        }
    }

    protected String getStyleClass() {
        String styleClass = this.row.getStyleClass();
        if (StringUtils.isNotBlank((String)styleClass)) {
            return styleClass;
        }
        return null;
    }

    public String toString() {
        return this.html.toString();
    }
}

