/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.view.html;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.ecside.core.TableModel;
import org.ecside.core.bean.Column;
import org.ecside.core.bean.Table;
import org.ecside.util.ECSideUtils;
import org.ecside.util.HtmlBuilder;
import org.ecside.view.html.BuilderUtils;

public class TableBuilder {
    private HtmlBuilder html;
    private TableModel model;
    private Table table;
    private boolean isClassic;

    public TableBuilder(TableModel model) {
        this(new HtmlBuilder(), model);
    }

    public TableBuilder(HtmlBuilder html, TableModel model) {
        this.html = html;
        this.model = model;
        this.table = model.getTable();
        this.isClassic = this.table.isClassic();
    }

    public HtmlBuilder getHtmlBuilder() {
        return this.html;
    }

    protected TableModel getTableModel() {
        return this.model;
    }

    protected Table getTable() {
        return this.table;
    }

    public void tableStart() {
        this.html.table(0);
        this.id();
        this.border();
        this.cellSpacing();
        this.cellPadding();
        this.styleClass();
        this.style();
        this.width();
        this.height();
        this.html.append(" ").append(ECSideUtils.nullToBlank(this.table.getTagAttributes())).append(" ");
        this.html.append(this.table.getAttribute("attributes"));
        this.html.close();
    }

    public void tableStartH() {
        this.html.table(0);
        this.border();
        this.cellSpacing();
        this.cellPadding();
        this.styleClass();
        this.style();
        this.width();
        this.height();
        this.html.append(" ").append(ECSideUtils.nullToBlank(this.table.getTagAttributes())).append(" ");
        this.html.append(this.table.getAttribute("attributes"));
        this.html.close();
    }

    public void tableEnd() {
        this.html.tableEnd(0);
    }

    public String getPrefixWithTableId() {
        return this.getTableModel().getTableHandler().prefixWithTableId();
    }

    public void id() {
        this.html.id(String.valueOf(this.model.getTableHandler().prefixWithTableId()) + "table");
    }

    public void border() {
        String border = this.table.getBorder();
        this.html.border(border);
    }

    public void cellSpacing() {
        String cellSpacing = this.table.getCellspacing();
        this.html.cellSpacing(cellSpacing);
    }

    public void cellPadding() {
        String cellPadding = this.table.getCellpadding();
        this.html.cellPadding(cellPadding);
    }

    public void styleClass() {
        String styleClass = this.table.getStyleClass();
        this.html.styleClass(styleClass);
    }

    public void style() {
        String style = StringUtils.isNotBlank((String)this.table.getStyle()) ? this.table.getStyle() : "";
        String fixed = "";
        boolean canResizeColWidth = this.model.getTable().isResizeColWidth();
        if (canResizeColWidth) {
            fixed = "table-layout:fixed;";
        }
        this.html.style(String.valueOf(fixed) + style);
    }

    public void height() {
        String height = this.table.getHeight();
        if (this.isClassic && StringUtils.isNotBlank((String)height)) {
            this.html.height(height);
        }
    }

    public void width() {
        String listWidth = this.table.getListWidth();
        String width = this.table.getWidth();
        if (this.isClassic) {
            this.html.width(width);
        } else {
            this.html.width(listWidth);
        }
    }

    public void title() {
        String title;
        boolean showTitle = BuilderUtils.showTitle(this.model);
        if (showTitle && StringUtils.isNotBlank((String)(title = this.table.getTitle()))) {
            String width = this.table.getWidth();
            if (width.indexOf("px") == -1 && width.indexOf("%") == -1) {
                width = String.valueOf(width) + "px";
            }
            this.html.newline();
            this.html.div().style("width:" + width + ";").styleClass("gridTitle").close().append(title).divEnd();
        }
    }

    public void headerRow() {
        boolean showHeader = this.model.getTable().isShowHeader();
        String hideStyle = "";
        if (!showHeader) {
            hideStyle = " style=\"display:none;\" ";
        }
        this.html.tr(1).append(hideStyle).close();
        List columns = this.model.getColumnHandler().getHeaderColumns();
        Iterator iter = columns.iterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            this.html.append(column.getCellDisplay());
            this.html.newline();
        }
        this.html.trEnd(1);
    }

    public void headerHideRow() {
        this.html.tr(1).id(String.valueOf(this.model.getTableHandler().prefixWithTableId()) + "hideListRow").styleClass("hideListRow").close();
        List columns = this.model.getColumnHandler().getHeaderColumns();
        Iterator iter = columns.iterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            this.html.td(2).valign("middle").append(" columnName=\"").append(column.getAlias()).append("\" ");
            this.html.width(column.getWidth());
            this.html.styleClass(column.getStyleClass());
            this.html.style(column.getStyle());
            if (StringUtils.isNotBlank((String)column.getNowrap())) {
                this.html.append(" nowrap=\"" + column.getNowrap() + "\" ");
            }
            if ("true".equalsIgnoreCase(column.getGroup())) {
                this.html.append(" group=\"true\" ");
            }
            if (column.isSortable()) {
                this.html.append(" sortable=\"true\" ");
            }
            this.html.close();
            this.html.append("&#160;");
            this.html.tdEnd();
        }
        this.html.trEnd(1);
    }

    public void bodyHideRow() {
        this.html.tr(1).styleClass("hideListRow").close();
        List columns = this.model.getColumnHandler().getHeaderColumns();
        Iterator iter = columns.iterator();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            this.html.td(2);
            this.html.width(column.getWidth());
            this.html.styleClass(column.getStyleClass());
            this.html.style(column.getStyle());
            if (StringUtils.isNotBlank((String)column.getNowrap())) {
                this.html.append(" nowrap=\"" + column.getNowrap() + "\" ");
            }
            this.html.close();
            this.html.append("&#160;");
            this.html.tdEnd();
        }
        this.html.trEnd(1);
    }

    public void theadStart() {
        this.html.thead(1).id(String.valueOf(this.model.getTableHandler().prefixWithTableId()) + "table" + "_head").close();
    }

    public void theadEnd() {
        this.html.theadEnd(1);
    }

    public void tbodyStart() {
        this.html.tbody(1).id(String.valueOf(this.model.getTableHandler().prefixWithTableId()) + "table" + "_body").close();
    }

    public void tbodyEnd() {
        this.html.tbodyEnd(1);
    }

    public void themeStart() {
        this.html.newline();
        String theme = this.model.getTable().getTheme();
        this.html.div().styleClass(theme);
        this.html.close();
    }

    public void themeEnd() {
        this.html.newline();
        this.html.divEnd();
    }

    public void buildWaitingBar() {
        this.html.div().id(String.valueOf(this.model.getTableHandler().prefixWithTableId()) + "waitingBar");
        this.html.styleClass("waitingBar").close();
        this.html.divEnd();
        this.html.div().id(String.valueOf(this.model.getTableHandler().prefixWithTableId()) + "waitingBarCore");
        this.html.styleClass("waitingBarCore").close();
        this.html.divEnd();
    }

    public void buildScript() {
        boolean generateScript = this.table.isGenerateScript();
        if (generateScript) {
            boolean useAjax = this.table.isUseAjax();
            boolean doPreload = this.table.isDoPreload();
            boolean isClassic = this.table.isClassic();
            StringBuffer jscript = new StringBuffer();
            jscript.append("\n<script type=\"text/javascript\" >\n");
            jscript.append("(function(){ \n");
            jscript.append(" var gird=ECSideUtil.createGird('" + this.table.getTableId() + "');").append(" \n");
            jscript.append(" gird.useAjax=" + useAjax + "; ").append(" \n");
            jscript.append(" gird.doPreload=" + doPreload + ";").append(" \n");
            jscript.append(" gird.isClassic=" + isClassic + ";").append(" \n");
            if (StringUtils.isNotBlank((String)this.table.getMinHeight())) {
                jscript.append(" gird.minHeight='" + this.table.getMinHeight() + "';").append(" \n");
            }
            jscript.append("})();");
            jscript.append("\n</script>\n");
            this.html.append(jscript.toString());
        }
    }

    public String toString() {
        return this.html.toString();
    }
}

