/*
 * Decompiled with CFR 0.152.
 */
package org.ecside.view.html;

import org.ecside.core.TableModel;
import org.ecside.util.HtmlBuilder;

public abstract class TwoColumnRowLayout {
    private HtmlBuilder html;
    private TableModel model;

    public TwoColumnRowLayout(HtmlBuilder html, TableModel model) {
        this.html = html;
        this.model = model;
    }

    protected HtmlBuilder getHtmlBuilder() {
        return this.html;
    }

    protected TableModel getTableModel() {
        return this.model;
    }

    public void layout() {
        if (!this.showLayout(this.model)) {
            return;
        }
        this.html.tr(1).style("padding: 0px;").close();
        this.html.td(2).colSpan(String.valueOf(this.model.getColumnHandler().columnCount())).close();
        this.html.table(2).border("0").cellPadding("0").cellSpacing("0").width("100%").close();
        this.html.tr(3).close();
        this.columnLeft(this.html, this.model);
        this.columnRight(this.html, this.model);
        this.html.trEnd(3);
        this.html.tableEnd(2);
        this.html.newline();
        this.html.tabs(2);
        this.html.tdEnd();
        this.html.trEnd(1);
        this.html.tabs(2);
        this.html.newline();
    }

    public String toString() {
        return this.html.toString();
    }

    protected abstract boolean showLayout(TableModel var1);

    protected abstract void columnLeft(HtmlBuilder var1, TableModel var2);

    protected abstract void columnRight(HtmlBuilder var1, TableModel var2);
}

