/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.dwrp.Alarm;
import org.directwebremoting.dwrp.BaseScriptConduit;
import org.directwebremoting.dwrp.Html4kScriptConduit;
import org.directwebremoting.dwrp.HtmlScriptConduit;
import org.directwebremoting.dwrp.JettyContinuationSleeper;
import org.directwebremoting.dwrp.OutputAlarm;
import org.directwebremoting.dwrp.PlainScriptConduit;
import org.directwebremoting.dwrp.PollBatch;
import org.directwebremoting.dwrp.ShutdownAlarm;
import org.directwebremoting.dwrp.Sleeper;
import org.directwebremoting.dwrp.ThreadWaitSleeper;
import org.directwebremoting.dwrp.TimedAlarm;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.Handler;
import org.directwebremoting.extend.PageNormalizer;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.ScriptSessionManager;
import org.directwebremoting.extend.ServerException;
import org.directwebremoting.extend.ServerLoadMonitor;
import org.directwebremoting.util.Continuation;

public class PollHandler
implements Handler {
    protected String sessionCookieName = "JSESSIONID";
    protected boolean activeReverseAjaxEnabled = false;
    protected boolean allowGetForSafariButMakeForgeryEasier = false;
    protected int maxWaitAfterWrite = -1;
    protected boolean plain;
    protected boolean crossDomainSessionSecurity = true;
    protected PageNormalizer pageNormalizer;
    protected ServerLoadMonitor serverLoadMonitor = null;
    protected ConverterManager converterManager = null;
    protected ScriptSessionManager scriptSessionManager = null;
    protected static final Log log = LogFactory.getLog((Class)(class$org$directwebremoting$dwrp$PollHandler == null ? (class$org$directwebremoting$dwrp$PollHandler = PollHandler.class$("org.directwebremoting.dwrp.PollHandler")) : class$org$directwebremoting$dwrp$PollHandler));
    static /* synthetic */ Class class$org$directwebremoting$dwrp$PollHandler;

    public PollHandler(boolean plain) {
        this.plain = plain;
    }

    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PollBatch batch;
        if (JettyContinuationSleeper.isRestart(request)) {
            JettyContinuationSleeper.restart(request);
            return;
        }
        try {
            batch = new PollBatch(request, this.pageNormalizer);
        }
        catch (ServerException ex) {
            String script = EnginePrivate.getRemoteHandleBatchExceptionScript(null, ex);
            this.sendErrorScript(response, script);
            return;
        }
        String bodySessionId = batch.getHttpSessionId();
        if (this.crossDomainSessionSecurity) {
            this.checkNotCsrfAttack(request, bodySessionId);
        }
        if (!this.activeReverseAjaxEnabled) {
            log.error((Object)"Polling and Comet are disabled. To enable them set the init-param activeReverseAjaxEnabled to true. See http://getahead.org/dwr/server/servlet for more.");
            String script = EnginePrivate.getRemotePollCometDisabledScript(batch.getBatchId());
            this.sendErrorScript(response, script);
            return;
        }
        if (batch.isGet() && !this.allowGetForSafariButMakeForgeryEasier) {
            String script = EnginePrivate.getRemoteHandleBatchExceptionScript(batch.getBatchId(), new SecurityException("GET Disallowed"));
            this.sendErrorScript(response, script);
            return;
        }
        final RealScriptSession scriptSession = batch.getScriptSession();
        final BaseScriptConduit conduit = this.createScriptConduit(batch, response);
        Sleeper sleeper = Continuation.isJetty() ? new JettyContinuationSleeper(request) : new ThreadWaitSleeper();
        final ArrayList<Alarm> alarms = new ArrayList<Alarm>();
        alarms.add(conduit.getErrorAlarm());
        if (batch.getPartialResponse() == 0 || this.maxWaitAfterWrite != -1) {
            alarms.add(new OutputAlarm(scriptSession, this.maxWaitAfterWrite));
        }
        long connectedTime = this.serverLoadMonitor.getConnectedTime();
        alarms.add(new TimedAlarm(connectedTime));
        alarms.add(new ShutdownAlarm(this.serverLoadMonitor));
        Iterator it = alarms.iterator();
        while (it.hasNext()) {
            Alarm alarm = (Alarm)it.next();
            alarm.setAlarmAction(sleeper);
        }
        scriptSession.addScriptConduit(conduit);
        Runnable onAwakening = new Runnable(){

            public void run() {
                Iterator it = alarms.iterator();
                while (it.hasNext()) {
                    Alarm alarm = (Alarm)it.next();
                    alarm.cancel();
                }
                scriptSession.removeScriptConduit(conduit);
                try {
                    int timeToNextPoll = PollHandler.this.serverLoadMonitor.getDisconnectedTime();
                    conduit.close(timeToNextPoll);
                }
                catch (IOException ex) {
                    log.warn((Object)"Failed to write reconnect info to browser");
                }
            }
        };
        sleeper.goToSleep(onAwakening);
    }

    private void checkNotCsrfAttack(HttpServletRequest request, String bodySessionId) {
        String headerSessionId;
        if (request.isRequestedSessionIdValid() && request.isRequestedSessionIdFromCookie() && (headerSessionId = request.getRequestedSessionId()).length() > 0) {
            if (headerSessionId.equals(bodySessionId)) {
                return;
            }
            Cookie[] cookies = request.getCookies();
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (!cookie.getName().equals(this.sessionCookieName) || !cookie.getValue().equals(bodySessionId)) continue;
                return;
            }
            log.error((Object)"A request has been denied as a potential CSRF attack.");
            throw new SecurityException("Session Error");
        }
    }

    private BaseScriptConduit createScriptConduit(PollBatch batch, HttpServletResponse response) throws IOException {
        BaseScriptConduit conduit = this.plain ? new PlainScriptConduit(response, batch.getBatchId(), this.converterManager) : (batch.getPartialResponse() == 2 ? new Html4kScriptConduit(response, batch.getBatchId(), this.converterManager) : new HtmlScriptConduit(response, batch.getBatchId(), this.converterManager));
        return conduit;
    }

    protected void sendErrorScript(HttpServletResponse response, String script) throws IOException {
        PrintWriter out = response.getWriter();
        if (this.plain) {
            response.setContentType("text/plain");
        } else {
            response.setContentType("text/html ");
        }
        out.println("//#DWR-START#");
        out.println(script);
        out.println("//#DWR-END#");
    }

    public void setCrossDomainSessionSecurity(boolean crossDomainSessionSecurity) {
        this.crossDomainSessionSecurity = crossDomainSessionSecurity;
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setServerLoadMonitor(ServerLoadMonitor serverLoadMonitor) {
        this.serverLoadMonitor = serverLoadMonitor;
    }

    public void setPageNormalizer(PageNormalizer pageNormalizer) {
        this.pageNormalizer = pageNormalizer;
    }

    public void setScriptSessionManager(ScriptSessionManager scriptSessionManager) {
        this.scriptSessionManager = scriptSessionManager;
    }

    public void setSessionCookieName(String sessionCookieName) {
        this.sessionCookieName = sessionCookieName;
    }

    public void setPollAndCometEnabled(boolean pollAndCometEnabled) {
        this.activeReverseAjaxEnabled = pollAndCometEnabled;
    }

    public void setActiveReverseAjaxEnabled(boolean activeReverseAjaxEnabled) {
        this.activeReverseAjaxEnabled = activeReverseAjaxEnabled;
    }

    public void setAllowGetForSafariButMakeForgeryEasier(boolean allowGetForSafariButMakeForgeryEasier) {
        this.allowGetForSafariButMakeForgeryEasier = allowGetForSafariButMakeForgeryEasier;
    }

    public void setMaxWaitAfterWrite(int maxWaitAfterWrite) {
        this.maxWaitAfterWrite = maxWaitAfterWrite;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

