/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.guice.spring;

import com.google.inject.Provider;
import java.io.Closeable;
import java.io.IOException;
import org.directwebremoting.guice.spring.BeanFactoryLoader;
import org.directwebremoting.util.Logger;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CloseableBeanFactoryProvider
implements Closeable,
Provider<BeanFactory> {
    private final BeanFactoryLoader loader;
    private BeanFactory beanFactory;
    private static final Logger log = Logger.getLogger(CloseableBeanFactoryProvider.class);

    CloseableBeanFactoryProvider(BeanFactoryLoader loader) {
        this.loader = loader;
    }

    public synchronized BeanFactory get() {
        if (this.beanFactory == null) {
            this.beanFactory = this.loader.loadBeanFactory();
        }
        return this.beanFactory;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.beanFactory != null && this.beanFactory instanceof DisposableBean) {
            try {
                ((DisposableBean)this.beanFactory).destroy();
                log.info("Destroyed BeanFactory from Guice provider.");
            }
            catch (IOException e) {
                log.info("Caught IO exception destroying BeanFactory: " + e);
                throw e;
            }
            catch (Exception e) {
                log.info("Unexpected exception while destroying BeanFactory: " + e);
                throw new RuntimeException(e);
            }
        }
    }
}

