/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.directwebremoting.Container;
import org.directwebremoting.impl.DefaultContainer;
import org.directwebremoting.util.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.util.ClassUtils;

public class SpringContainer
extends DefaultContainer
implements Container,
BeanFactoryAware,
InitializingBean {
    protected BeanFactory beanFactory;
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$spring$SpringContainer == null ? (class$org$directwebremoting$spring$SpringContainer = SpringContainer.class$("org.directwebremoting.spring.SpringContainer")) : class$org$directwebremoting$spring$SpringContainer);
    static /* synthetic */ Class class$org$directwebremoting$spring$SpringContainer;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void addParameter(Object askFor, Object valueParam) throws InstantiationException, IllegalAccessException {
        try {
            Class clz = ClassUtils.forName((String)((String)askFor));
            if (log.isDebugEnabled()) {
                log.debug("trying to resolve the following class from the Spring bean container: " + clz.getName());
            }
            Map beansOfType = ((ListableBeanFactory)this.beanFactory).getBeansOfType(clz);
            if (log.isDebugEnabled()) {
                log.debug("beans: " + beansOfType + " - " + beansOfType.size());
            }
            if (beansOfType.size() == 0) {
                log.debug("adding parameter the normal way");
                super.addParameter(askFor, valueParam);
            } else {
                if (beansOfType.size() > 1) {
                    throw new InstantiationException("multiple beans of type '" + clz.getName() + "' were found in the spring configuration");
                }
                this.beans.put(askFor, beansOfType.values().iterator().next());
            }
        }
        catch (ClassNotFoundException e) {
            super.addParameter(askFor, valueParam);
        }
    }

    public Object getBean(String id) {
        Object reply;
        try {
            reply = this.beanFactory.getBean(id);
        }
        catch (BeansException ex) {
            reply = super.getBean(id);
        }
        return reply;
    }

    public Collection getBeanNames() {
        ArrayList<String> names = new ArrayList<String>();
        if (this.beanFactory instanceof ListableBeanFactory) {
            ListableBeanFactory listable = (ListableBeanFactory)this.beanFactory;
            names.addAll(Arrays.asList(listable.getBeanDefinitionNames()));
        } else {
            log.warn("List of beanNames does not include Spring beans since your BeanFactory is not a ListableBeanFactory.");
        }
        names.addAll(super.getBeanNames());
        return Collections.unmodifiableCollection(names);
    }

    protected void callInitializingBeans() {
        this.callInitializingBeans(super.getBeanNames());
    }

    public void afterPropertiesSet() throws Exception {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

