/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta.xpath;

import java.io.IOException;
import java.io.Reader;

public class SimpleStreamTokenizer {
    public static final int TT_EOF = -1;
    public static final int TT_NUMBER = -2;
    public static final int TT_WORD = -3;
    public int ttype = Integer.MIN_VALUE;
    public int nval = Integer.MIN_VALUE;
    public String sval = "";
    private static final int WHITESPACE = -5;
    private static final int QUOTE = -6;
    private final StringBuffer buf_ = new StringBuffer();
    private int nextType_;
    private final Reader reader_;
    private final int[] charType_ = new int[256];
    private boolean pushedBack_ = false;
    private char inQuote_ = '\u0000';

    public String toString() {
        switch (this.ttype) {
            case -2: {
                return Integer.toString(this.nval);
            }
            case -3: 
            case 34: {
                return "\"" + this.sval + "\"";
            }
            case 39: {
                return "'" + this.sval + "'";
            }
            case -1: {
                return "(EOF)";
            }
        }
        return "'" + (char)this.ttype + "'";
    }

    public SimpleStreamTokenizer(Reader reader) throws IOException {
        this.reader_ = reader;
        int n = 0;
        while (n < this.charType_.length) {
            this.charType_[n] = 65 <= n && n <= 90 || 97 <= n && n <= 122 || n == 45 ? -3 : (48 <= n && n <= 57 ? -2 : (0 <= n && n <= 32 ? -5 : n));
            n = (char)(n + 1);
        }
        this.nextToken();
    }

    public void ordinaryChar(char c) {
        this.charType_[c] = c;
    }

    public void wordChars(char c, char c2) {
        char c3 = c;
        while (c3 <= c2) {
            this.charType_[c3] = -3;
            c3 = (char)(c3 + '\u0001');
        }
    }

    public int nextToken() throws IOException {
        boolean bl;
        if (this.pushedBack_) {
            this.pushedBack_ = false;
            return this.ttype;
        }
        this.ttype = this.nextType_;
        do {
            char c;
            int n;
            boolean bl2;
            bl = false;
            do {
                if ((n = this.reader_.read()) == -1) {
                    if (this.inQuote_ != '\u0000') {
                        throw new IOException("Unterminated quote");
                    }
                    c = '\uffffffff';
                } else {
                    c = this.charType_[n];
                }
                bl2 = this.inQuote_ == '\u0000' && c == '\ufffffffb';
                boolean bl3 = bl = bl || bl2;
            } while (bl2);
            if (c == '\'' || c == '\"') {
                if (this.inQuote_ == '\u0000') {
                    this.inQuote_ = c;
                } else if (this.inQuote_ == c) {
                    this.inQuote_ = '\u0000';
                }
            }
            if (this.inQuote_ != '\u0000') {
                c = this.inQuote_;
            }
            boolean bl4 = bl = bl || this.ttype >= -1 && this.ttype != 39 && this.ttype != 34 || this.ttype != c;
            if (bl) {
                switch (this.ttype) {
                    case -3: {
                        this.sval = this.buf_.toString();
                        this.buf_.setLength(0);
                        break;
                    }
                    case 34: 
                    case 39: {
                        this.sval = this.buf_.toString().substring(1, this.buf_.length() - 1);
                        this.buf_.setLength(0);
                        break;
                    }
                    case -2: {
                        this.nval = Integer.parseInt(this.buf_.toString());
                        this.buf_.setLength(0);
                        break;
                    }
                }
                if (c != '\ufffffffb') {
                    this.nextType_ = c == '\ufffffffa' ? n : (int)c;
                }
            }
            switch (c) {
                case '\ufffffffd': 
                case '\ufffffffe': 
                case '\"': 
                case '\'': {
                    this.buf_.append((char)n);
                    break;
                }
            }
        } while (!bl);
        return this.ttype;
    }

    public void pushBack() {
        this.pushedBack_ = true;
    }
}

