/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta.xpath;

import com.hp.hpl.sparta.xpath.AttrEqualsExpr;
import com.hp.hpl.sparta.xpath.AttrExistsExpr;
import com.hp.hpl.sparta.xpath.BooleanExpr;
import com.hp.hpl.sparta.xpath.SimpleStreamTokenizer;
import com.hp.hpl.sparta.xpath.Step;
import com.hp.hpl.sparta.xpath.XPathException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

public class XPath {
    private static final int ASSERTION = 0;
    private Stack steps_ = new Stack();
    private boolean absolute_;
    private String string_;
    private static Hashtable cache_ = new Hashtable();

    private XPath(boolean bl, Step[] stepArray) {
        int n = 0;
        while (n < stepArray.length) {
            this.steps_.addElement(stepArray[n]);
            ++n;
        }
        this.absolute_ = bl;
        this.string_ = null;
    }

    private XPath(String string) throws XPathException {
        this(string, new InputStreamReader(new ByteArrayInputStream(string.getBytes())));
    }

    private XPath(String string, Reader reader) throws XPathException {
        try {
            boolean bl;
            this.string_ = string;
            SimpleStreamTokenizer simpleStreamTokenizer = new SimpleStreamTokenizer(reader);
            simpleStreamTokenizer.ordinaryChar('/');
            simpleStreamTokenizer.ordinaryChar('.');
            simpleStreamTokenizer.wordChars(':', ':');
            simpleStreamTokenizer.wordChars('_', '_');
            if (simpleStreamTokenizer.nextToken() == 47) {
                this.absolute_ = true;
                if (simpleStreamTokenizer.nextToken() == 47) {
                    bl = true;
                    simpleStreamTokenizer.nextToken();
                } else {
                    bl = false;
                }
            } else {
                this.absolute_ = false;
                bl = false;
            }
            this.steps_.push(new Step(this, bl, simpleStreamTokenizer));
            while (simpleStreamTokenizer.ttype == 47) {
                if (simpleStreamTokenizer.nextToken() == 47) {
                    bl = true;
                    simpleStreamTokenizer.nextToken();
                } else {
                    bl = false;
                }
                this.steps_.push(new Step(this, bl, simpleStreamTokenizer));
            }
            if (simpleStreamTokenizer.ttype != -1) {
                throw new XPathException(this, "at end of XPATH expression", simpleStreamTokenizer, "end of expression");
            }
        }
        catch (IOException iOException) {
            throw new XPathException(this, iOException);
        }
    }

    public String toString() {
        if (this.string_ == null) {
            this.string_ = this.generateString();
        }
        return this.string_;
    }

    private String generateString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Enumeration enumeration = this.steps_.elements();
        while (enumeration.hasMoreElements()) {
            Step step = (Step)enumeration.nextElement();
            if (!bl || this.absolute_) {
                stringBuffer.append('/');
                if (step.isMultiLevel()) {
                    stringBuffer.append('/');
                }
            }
            stringBuffer.append(step.toString());
            bl = false;
        }
        return stringBuffer.toString();
    }

    public boolean isAbsolute() {
        return this.absolute_;
    }

    public boolean isStringValue() {
        Step step = (Step)this.steps_.peek();
        return step.isStringValue();
    }

    public Enumeration getSteps() {
        return this.steps_.elements();
    }

    public String getIndexingAttrName() throws XPathException {
        Step step = (Step)this.steps_.peek();
        BooleanExpr booleanExpr = step.getPredicate();
        if (!(booleanExpr instanceof AttrExistsExpr)) {
            throw new XPathException(this, "has no indexing attribute name (must end with predicate of the form [@attrName]");
        }
        return ((AttrExistsExpr)booleanExpr).getAttrName();
    }

    public String getIndexingAttrNameOfEquals() throws XPathException {
        Step step = (Step)this.steps_.peek();
        BooleanExpr booleanExpr = step.getPredicate();
        if (booleanExpr instanceof AttrEqualsExpr) {
            return ((AttrEqualsExpr)booleanExpr).getAttrName();
        }
        return null;
    }

    public Object clone() {
        Step[] stepArray = new Step[this.steps_.size()];
        Enumeration enumeration = this.steps_.elements();
        int n = 0;
        while (n < stepArray.length) {
            stepArray[n] = (Step)enumeration.nextElement();
            ++n;
        }
        return new XPath(this.absolute_, stepArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XPath get(String string) throws XPathException {
        Hashtable hashtable = cache_;
        synchronized (hashtable) {
            XPath xPath = (XPath)cache_.get(string);
            if (xPath == null) {
                xPath = new XPath(string);
                cache_.put(string, xPath);
            }
            return xPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XPath get(boolean bl, Step[] stepArray) {
        XPath xPath = new XPath(bl, stepArray);
        String string = xPath.toString();
        Hashtable hashtable = cache_;
        synchronized (hashtable) {
            XPath xPath2 = (XPath)cache_.get(string);
            if (xPath2 == null) {
                cache_.put(string, xPath);
                return xPath;
            }
            return xPath2;
        }
    }

    public static boolean isStringValue(String string) throws XPathException, IOException {
        return XPath.get(string).isStringValue();
    }
}

