/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.springframework.binding.expression.EvaluationContext;
import org.springframework.binding.expression.Expression;
import org.springframework.util.Assert;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.action.ActionResultExposer;
import org.springframework.webflow.action.ResultEventFactorySelector;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class EvaluateAction
extends AbstractAction {
    private Expression expression;
    private ActionResultExposer evaluationResultExposer;
    private ResultEventFactorySelector resultEventFactorySelector = new ResultEventFactorySelector();

    public EvaluateAction(Expression expression) {
        this(expression, null);
    }

    public EvaluateAction(Expression expression, ActionResultExposer evaluationResultExposer) {
        Assert.notNull((Object)expression, (String)"The expression this action should evaluate is required");
        this.expression = expression;
        this.evaluationResultExposer = evaluationResultExposer;
    }

    protected Event doExecute(RequestContext context) throws Exception {
        Object result = this.expression.evaluate((Object)context, this.getEvaluationContext(context));
        if (this.evaluationResultExposer != null) {
            this.evaluationResultExposer.exposeResult(result, context);
        }
        return this.resultEventFactorySelector.forResult(result).createResultEvent(this, result, context);
    }

    protected EvaluationContext getEvaluationContext(RequestContext context) {
        return null;
    }
}

